/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.test;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.history.TermMacroHistoryItem;
import org.obo.nlp.Namer;
import org.obo.nlp.impl.RegulationTermParser;
import org.obo.nlp.test.AbstractNLPTest;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.LinkPileReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegulationTermParserTest
extends AbstractNLPTest {
    protected static final Logger logger = Logger.getLogger(RegulationTermParserTest.class);

    public RegulationTermParserTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"regulation_of_transcription.obo"};
        return Arrays.asList(files);
    }

    public void testLinks() throws Exception {
        this.semanticParser = new RegulationTermParser();
        this.semanticParser.index(this.session);
        Collection<TermMacroHistoryItem> items = this.semanticParser.parseTerms();
        for (TermMacroHistoryItem item : items) {
            logger.info((Object)item);
        }
        this.semanticParser.apply(items);
        int passes = 0;
        for (String report : this.semanticParser.getReports()) {
            logger.info((Object)report);
            if (report.contains("MISSING_LINK: GO:0019219")) {
                ++passes;
            }
            if (!report.contains("NO_TARGET: GO:0021882")) continue;
            ++passes;
        }
        RegulationTermParserTest.assertTrue((passes == 2 ? 1 : 0) != 0);
        OBOProperty nrProp = (OBOProperty)this.session.getObject("negatively_regulates");
        this.testForIsA("negatively_regulates", "regulates");
        this.testForTransitiveOver("negatively_regulates", "part_of");
        String id = "GO:0031323";
        this.testForGenus(id, "GO:0065007");
        this.testForDifferentium(id, "regulates", "GO:0044237");
        this.testForNoIsA(id, "GO:0019222");
        LinkPileReasonerFactory rf = new LinkPileReasonerFactory();
        ReasonedLinkDatabase reasoner = rf.createReasoner();
        reasoner.setLinkDatabase(this.session.getLinkDatabase());
        reasoner.recache();
        this.testForIsA(reasoner, id, "GO:0019222");
        this.testForIsA(reasoner, "GO:0045449", "GO:0010468");
        this.semanticParser.useDefaultNamer();
        Namer namer = this.semanticParser.getNamer();
        id = "GO:0019222";
        LinkedObject lo = (LinkedObject)this.session.getObject(id);
        Collection<String> names = namer.constructNames(lo);
        logger.info(names);
        RegulationTermParserTest.assertTrue((boolean)names.contains("regulation of metabolism"));
        RegulationTermParserTest.assertTrue((names.size() == 1 ? 1 : 0) != 0);
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new RegulationTermParserTest("testLinks"));
    }
}

