/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.dataadapter;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.DefaultIOOperation;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.GraphicalUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.ProgressableInputStream;
import org.bbop.util.AbstractProgressValued;
import org.coode.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.obo.parser.OBOOntologyFormat;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Value;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.DatatypeValueImpl;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.datamodel.impl.PropertyValueImpl;
import org.obo.owl.datamodel.MetadataMapping;
import org.obo.owl.util.IDSpaceRegistry;
import org.obo.util.IDUtil;
import org.obo.util.TermUtil;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.DefaultOntologyFormat;
import org.semanticweb.owl.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owl.io.OWLXMLOntologyFormat;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.SimpleURIMapper;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAdapter
extends AbstractProgressValued
implements DataAdapter {
    protected static final Logger logger = Logger.getLogger((String)"OWLAdapter.class");
    protected String path;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected OWLAdapterConfiguration ioprofile;
    protected GraphicalUI advancedUI;
    protected List streams = new LinkedList();
    protected OWLDataFactory owlFactory;
    protected URI ontologyURI;
    protected OWLOntology ontology;
    protected OWLOntologyManager manager;
    protected Map<OWLDescription, OBOClass> description2oboclass = new HashMap<OWLDescription, OBOClass>();
    public static final String PURL_OBO = "http://purl.org/obo/";
    public static final String PURL_OBO_OWL = "http://purl.org/obo/owl/";
    OBOSession session;
    private Object owlProp;
    public static final IOOperation<OBOSession, OBOSession> WRITE_ONTOLOGY = new DefaultIOOperation("WRITE_ONTOLOGY", "write ontology", OBOSession.class, OBOSession.class);
    public static final IOOperation<Void, OBOSession> READ_ONTOLOGY = new DefaultIOOperation("READ_ONTOLOGY", "read ontology", Void.class, OBOSession.class);

    public String getID() {
        return "OBO:OWLAdapter";
    }

    public String getName() {
        return "OBO OWL Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{READ_ONTOLOGY, WRITE_ONTOLOGY};
        return supported;
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI(){
            private static final long serialVersionUID = 8709597443707849569L;

            public AdapterConfiguration createEmptyConfig() {
                return new OWLAdapterConfiguration();
            }

            public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
                super.acceptComponentConfig(storeonly);
                ((OWLAdapterConfiguration)this.config).setBasicSave(true);
            }
        };
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        GraphicalUI advancedUI = this.getAdvancedUI();
        if (advancedUI != null) {
            advancedUI.setSimpleUI((GraphicalUI)ui);
            ui.setAdvancedUI(advancedUI);
        }
        return ui;
    }

    public GraphicalUI getAdvancedUI() {
        return this.advancedUI;
    }

    public void setAdvancedUI(GraphicalUI advancedUI) {
        this.advancedUI = advancedUI;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fireLossyWarning(String message, OBOObject obj) throws DataAdapterException {
        this.fireLossyWarning(message + " object:" + obj);
    }

    public void fireLossyWarning(String message) throws DataAdapterException {
        if (!this.ioprofile.allowLossy) {
            throw new DataAdapterException(message + " -- set allowLossy to true to ignore this message");
        }
        logger.error((Object)message);
    }

    public AdapterConfiguration getConfiguration() {
        return this.ioprofile;
    }

    public void setConfiguration(OWLAdapterConfiguration config) {
        this.ioprofile = config;
    }

    public <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE doOperation(IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, AdapterConfiguration configuration, INPUT_TYPE input) throws DataAdapterException {
        if (!(configuration instanceof OWLAdapterConfiguration)) {
            logger.info((Object)("conf=" + configuration.getClass()));
            throw new DataAdapterException(" - Invalid configuration; this adapter requires an OWLAdapterConfiguration object.");
        }
        this.cancelled = false;
        this.ioprofile = (OWLAdapterConfiguration)configuration;
        if (op.equals(READ_ONTOLOGY)) {
            OBOSession session = new DefaultObjectFactory().createSession();
            session.setDefaultNamespace(session.getObjectFactory().createNamespace("test", "test"));
            for (String f : this.ioprofile.getReadPaths()) {
                this.readOntology(session, f);
            }
            return (OUTPUT_TYPE)session;
        }
        if (op.equals(WRITE_ONTOLOGY)) {
            LinkedList<OBOSerializationEngine.FilteredPath> filteredPaths = new LinkedList<OBOSerializationEngine.FilteredPath>();
            if (this.ioprofile.getBasicSave()) {
                filteredPaths.add(new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath()));
            } else {
                logger.info((Object)("getSaveRecprds=" + this.ioprofile.getSaveRecords()));
                filteredPaths.addAll(this.ioprofile.getSaveRecords());
            }
            this.streams.clear();
            Iterator it = filteredPaths.iterator();
            this.session = (OBOSession)input;
            if (it.hasNext()) {
                OBOSerializationEngine.FilteredPath filteredPath = (OBOSerializationEngine.FilteredPath)it.next();
                this.writeAll((OBOSession)input, filteredPath.getPath(), filteredPath);
                return (OUTPUT_TYPE)input;
            }
        }
        return null;
    }

    public void readOntology(OBOSession session, String f) throws DataAdapterException {
        this.manager = OWLManager.createOWLOntologyManager();
        this.session = session;
        URI uri = f.indexOf(":") > 0 ? URI.create(f) : URI.create("file:" + f);
        logger.info((Object)("reading OWL ontology from URI " + uri));
        try {
            this.ontology = this.manager.loadOntologyFromPhysicalURI(uri);
        }
        catch (Exception e) {
            logger.info((Object)("Error reading OWL ontology from " + uri + ": " + e));
            e.printStackTrace();
            throw new DataAdapterException("error reading OWL ontology from " + uri + ": " + e);
        }
        if (this.ioprofile.isCombineOWLOntologies()) {
            Iterator i$ = this.manager.getOntologies().iterator();
            while (i$.hasNext()) {
                OWLOntology ont;
                this.ontology = ont = (OWLOntology)i$.next();
                logger.info((Object)("ontology: " + ont));
                this.transformToOBOSession(this.ontology, session);
            }
        } else {
            this.transformToOBOSession(this.ontology, session);
        }
    }

    public void transformToOBOSession(OWLOntology ontology, OBOSession session) throws DataAdapterException {
        OBOProperty oboProperty;
        Set owlAnnotationAxioms;
        OBOClass oboClass;
        String id;
        ObjectFactory oboFactory = session.getObjectFactory();
        for (OWLIndividual owlIndividual : ontology.getReferencedIndividuals()) {
            id = this.getOboID(owlIndividual.getURI());
            Instance oboInstance = (Instance)oboFactory.createObject(id, OBOClass.OBO_INSTANCE, false);
            session.addObject(oboInstance);
            Map opvs = owlIndividual.getObjectPropertyValues(ontology);
            for (OWLObjectPropertyExpression owlProp : opvs.keySet()) {
                if (!(owlProp instanceof OWLProperty)) continue;
                OBOProperty oboProp = this.getOboProperty((OWLProperty)owlProp);
                for (OWLIndividual owlRefIndiv : (Set)opvs.get(owlProp)) {
                    String toID = this.getOboID((OWLEntity)owlRefIndiv);
                    Instance oboRefInst = this.getOboInstance(toID);
                    if (!(oboRefInst instanceof Value)) continue;
                    oboInstance.addPropertyValue(oboProp, oboRefInst);
                    logger.debug((Object)("PV: " + oboProp + " = " + oboRefInst));
                }
            }
            Map dpvs = owlIndividual.getDataPropertyValues(ontology);
            for (OWLDataPropertyExpression owlProp : dpvs.keySet()) {
                if (!(owlProp instanceof OWLProperty)) continue;
                OBOProperty oboProp = this.getOboProperty((OWLProperty)owlProp);
                for (OWLConstant owlConst : (Set)dpvs.get(owlProp)) {
                    DatatypeValueImpl<String> dv = new DatatypeValueImpl<String>(Datatype.STRING, owlConst.getLiteral());
                    oboInstance.addPropertyValue(oboProp, dv);
                    logger.debug((Object)("PV: " + oboProp + " = " + dv));
                }
            }
            Set owlTypes = owlIndividual.getTypes(ontology);
            for (OWLDescription owlDesc : owlTypes) {
                OBOClass oboClass2 = this.getOboClass(owlDesc);
                oboInstance.setType(oboClass2);
            }
            if (owlTypes.size() > 1) {
                this.fireLossyWarning("multiple instance_of links set (obo allows only one for now)", oboInstance);
            }
            Set owlAnnotationAxioms2 = owlIndividual.getAnnotationAxioms(ontology);
            this.getMetadataFromAnnotationAxioms(oboInstance, owlAnnotationAxioms2);
        }
        for (OWLClass owlClass : ontology.getReferencedClasses()) {
            id = this.getOboID(owlClass.getURI());
            oboClass = (OBOClass)oboFactory.createObject(id, OBOClass.OBO_CLASS, false);
            session.addObject(oboClass);
        }
        for (OWLClass owlClass : ontology.getReferencedClasses()) {
            id = this.getOboID(owlClass.getURI());
            oboClass = (OBOClass)session.getObject(id);
            owlAnnotationAxioms = owlClass.getAnnotationAxioms(ontology);
            this.getMetadataFromAnnotationAxioms(oboClass, owlAnnotationAxioms);
            for (OWLSubClassAxiom axiom : ontology.getSubClassAxiomsForLHS(owlClass)) {
                OWLDescription owlSuper = axiom.getSuperClass();
                OBORestriction link = this.getOboLinkFromOWLDescription(owlSuper, oboClass);
                if (link == null) {
                    this.fireLossyWarning("Cannot convert OWLDescription: " + owlSuper);
                    continue;
                }
                oboClass.addParent(link);
            }
            for (OWLSubClassAxiom axiom : ontology.getEquivalentClassesAxioms(owlClass)) {
                Set ecDescs = axiom.getDescriptions();
                if (ecDescs.size() != 2) {
                    this.fireLossyWarning("all OWLEquivalentClassesAxiom must be pairs; got:" + ecDescs);
                    continue;
                }
                OWLDescription equivTo = null;
                for (OWLDescription d : ecDescs) {
                    if (d.equals(owlClass)) continue;
                    if (equivTo != null) {
                        this.fireLossyWarning("all OWLEquivalentClassesAxiom must be pairs; got:" + ecDescs);
                        continue;
                    }
                    equivTo = d;
                }
                this.addDescription(oboClass, equivTo);
            }
            for (OWLDescription owlDisjointClass : owlClass.getDisjointClasses(ontology)) {
                OBOClass oboDisjointClass = this.getOboClass(owlDisjointClass);
                if (oboDisjointClass != null) {
                    oboClass.addParent(new OBORestrictionImpl((LinkedObject)oboClass, OBOProperty.DISJOINT_FROM, oboDisjointClass));
                    continue;
                }
                this.fireLossyWarning("disjointWith axioms must be to named classes. Can't handle: " + oboClass + " with " + owlDisjointClass);
            }
        }
        for (OWLDataProperty owlProperty : ontology.getReferencedDataProperties()) {
            id = this.getOboID((OWLEntity)owlProperty);
            oboProperty = (OBOProperty)oboFactory.createObject(id, OBOClass.OBO_PROPERTY, false);
            session.addObject(oboProperty);
            owlAnnotationAxioms = owlProperty.getAnnotationAxioms(ontology);
            this.getMetadataFromAnnotationAxioms(oboProperty, owlAnnotationAxioms);
        }
        for (OWLDataProperty owlProperty : ontology.getReferencedObjectProperties()) {
            id = this.getOboID((OWLEntity)owlProperty);
            oboProperty = (OBOProperty)oboFactory.createObject(id, OBOClass.OBO_PROPERTY, false);
            session.addObject(oboProperty);
            owlAnnotationAxioms = owlProperty.getAnnotationAxioms(ontology);
            this.getMetadataFromAnnotationAxioms(oboProperty, owlAnnotationAxioms);
            if (owlProperty.isFunctional(ontology)) {
                // empty if block
            }
            if (!(owlProperty instanceof OWLObjectProperty)) continue;
            OWLObjectProperty owlObjectProperty = (OWLObjectProperty)owlProperty;
            if (owlObjectProperty.isTransitive(ontology)) {
                oboProperty.setTransitive(true);
            }
            if (owlObjectProperty.isSymmetric(ontology)) {
                oboProperty.setSymmetric(true);
            }
            if (!owlObjectProperty.isReflexive(ontology)) continue;
            oboProperty.setReflexive(true);
        }
        for (MetadataMapping mapping : this.ioprofile.getMetadataMappings()) {
            mapping.translateGraph(session);
        }
        TermUtil.resolveDanglingLinks(session);
    }

    public void addDescription(OBOClass oboClass, OWLDescription owlDesc) throws DataAdapterException {
        block8: {
            block7: {
                if (!(owlDesc instanceof OWLObjectIntersectionOf)) break block7;
                Set elts = ((OWLObjectIntersectionOf)owlDesc).getOperands();
                for (OWLDescription d : elts) {
                    OBORestriction link = this.getOboLinkFromOWLDescription(d, oboClass);
                    if (link == null) {
                        String message = "Cannot convert OWLDescription: " + d + " -- in " + owlDesc;
                        if (this.ioprofile.allowLossy) {
                            logger.info((Object)message);
                            continue;
                        }
                        throw new DataAdapterException(message);
                    }
                    link.setCompletes(true);
                    oboClass.addParent(link);
                }
                break block8;
            }
            if (!(owlDesc instanceof OWLObjectUnionOf)) break block8;
            Set elts = ((OWLObjectUnionOf)owlDesc).getOperands();
            for (OWLDescription d : elts) {
                OBORestriction link = this.getOboLinkFromOWLDescription(d, oboClass);
                if (link == null) {
                    String message = "Cannot convert OWLDescription: " + d + " -- in " + owlDesc;
                    if (this.ioprofile.allowLossy) {
                        logger.info((Object)message);
                        continue;
                    }
                    throw new DataAdapterException(message);
                }
                if (link.getType().equals(OBOProperty.IS_A)) {
                    link.setType(OBOProperty.UNION_OF);
                    oboClass.addParent(link);
                    continue;
                }
                this.fireLossyWarning("cannot deal with " + link + " in UnionOf " + owlDesc);
            }
        }
    }

    public OBORestriction getOboLinkFromOWLDescription(OWLDescription desc, OBOClass oboClass) throws DataAdapterException {
        ObjectFactory oboFactory = this.session.getObjectFactory();
        OBORestriction link = null;
        if (desc instanceof OWLClass) {
            OBOProperty oboProp = OBOProperty.IS_A;
            OBOClass oboParentClass = this.getOboClass((OWLDescription)((OWLClass)desc));
            link = oboFactory.createOBORestriction(oboClass, oboProp, oboParentClass, false);
            logger.debug((Object)("subclass of named class: " + desc + " :: " + link));
        } else if (desc instanceof OWLObjectSomeRestriction) {
            OWLObjectSomeRestriction restr = (OWLObjectSomeRestriction)desc;
            OBOProperty oboProp = this.getOboProperty((OWLProperty)((OWLObjectPropertyExpression)restr.getProperty()).asOWLObjectProperty());
            OBOClass oboParentClass = this.getOboClass((OWLDescription)restr.getFiller());
            link = oboFactory.createOBORestriction(oboClass, oboProp, oboParentClass, false);
            logger.debug((Object)("subclass of existential restriction: " + desc + " :: " + link));
        } else if (desc instanceof OWLObjectAllRestriction) {
            logger.debug((Object)("subclass of universal restriction: " + desc + " :: " + link));
        } else if (desc instanceof OWLObjectCardinalityRestriction) {
            OWLObjectCardinalityRestriction restr = (OWLObjectCardinalityRestriction)desc;
            OBOProperty oboProp = this.getOboProperty((OWLProperty)((OWLObjectPropertyExpression)restr.getProperty()).asOWLObjectProperty());
            OBOClass oboParentClass = this.getOboClass((OWLDescription)restr.getFiller());
            int card = restr.getCardinality();
            link = oboFactory.createOBORestriction(oboClass, oboProp, oboParentClass, false);
            if (restr instanceof OWLObjectMinCardinalityRestriction) {
                link.setMinCardinality(card);
            } else if (restr instanceof OWLObjectMaxCardinalityRestriction) {
                link.setMaxCardinality(card);
            } else if (restr instanceof OWLObjectExactCardinalityRestriction) {
                link.setCardinality(card);
            } else {
                this.fireLossyWarning("unknown class of OWLObjectCardinalityRestriction: " + desc);
            }
            logger.debug((Object)("subclass of QCR: " + desc + " :: " + link));
        } else if (desc instanceof OWLObjectIntersectionOf) {
            OBOProperty oboProp = OBOProperty.IS_A;
            OBOClass oboParentClass = this.getOboClass(desc);
            link = oboFactory.createOBORestriction(oboClass, oboProp, oboParentClass, false);
            logger.debug((Object)("subclass of intersection: " + desc + " :: " + link));
        }
        if (link != null && link.getParent() == null) {
            this.fireLossyWarning("incomplete link: " + link + "; from conversion of: " + desc);
            link = null;
        }
        return link;
    }

    public OBOClass getOboClass(OWLDescription owlDesc) throws DataAdapterException {
        OBOClass oboClass;
        if (this.description2oboclass.containsKey(owlDesc)) {
            return this.description2oboclass.get(owlDesc);
        }
        if (owlDesc.isAnonymous()) {
            String id = IDUtil.fetchTemporaryID(this.session);
            OBOClass oboClass2 = (OBOClass)this.session.getObjectFactory().createObject(id, OBOClass.OBO_CLASS, true);
            oboClass2.setIsAnonymous(true);
            this.session.addObject(oboClass2);
            this.addDescription(oboClass2, owlDesc);
            this.description2oboclass.put(owlDesc, oboClass2);
            return oboClass2;
        }
        OWLClass owlClass = (OWLClass)owlDesc;
        String id = this.getOboID((OWLEntity)owlClass);
        IdentifiedObject o = this.session.getObject(id);
        if (o == null) {
            oboClass = TermUtil.castToClass(this.session.getObjectFactory().createDanglingObject(id, false));
            this.session.addObject(oboClass);
        } else if (o instanceof OBOClass) {
            oboClass = (OBOClass)o;
        } else {
            this.fireLossyWarning("don't know what to do with " + owlDesc + "; expected class, got: " + o);
            return null;
        }
        this.description2oboclass.put(owlDesc, oboClass);
        return oboClass;
    }

    public String getOboID(OWLEntity oe) {
        return this.getOboID(oe.getURI());
    }

    public String getOboID(URI uri) {
        IDSpaceRegistry registry = IDSpaceRegistry.getInstance();
        String uriString = uri.toString();
        if (uriString.startsWith(PURL_OBO_OWL)) {
            String[] idParts = StringUtils.split((String)StringUtils.removeStart((String)uriString, (String)PURL_OBO_OWL), (String)"#", (int)2);
            if (idParts.length == 2) {
                return this.getOboID(idParts[0], idParts[1]);
            }
            logger.info((Object)("URI " + uriString + " does not conform to purl.org/obo standard"));
        }
        for (URI uriPrefix : registry.getUris()) {
            String uriPrefixString = uriPrefix.toString();
            if (!uriString.startsWith(uriPrefixString)) continue;
            String localId = StringUtils.removeStart((String)uriString, (String)uriPrefixString);
            String idspace = registry.getUriToIDSpace().get(uriPrefix);
            this.session.addIDSpace(idspace, uriPrefixString);
            return this.getOboID(idspace, localId);
        }
        return uriString;
    }

    public String getOboID(String prefix, String localId) {
        if (prefix.equals("obo")) {
            return localId;
        }
        if (localId.startsWith(prefix + "_")) {
            localId = StringUtils.removeStart((String)localId, (String)(prefix + "_"));
        }
        String id = prefix + ":" + localId;
        return id;
    }

    public void getMetadataFromAnnotationAxioms(IdentifiedObject lo, Set<OWLAnnotationAxiom> axioms) {
        HashSet<OWLAnnotationAxiom> unprocessedAxioms = new HashSet<OWLAnnotationAxiom>();
        for (OWLAnnotationAxiom axiom : axioms) {
            boolean isProcessed = false;
            OWLAnnotation owlAnnot = axiom.getAnnotation();
            if (owlAnnot instanceof OWLConstantAnnotation) {
                URI uri = owlAnnot.getAnnotationURI();
                String val = owlAnnot.getAnnotationValueAsConstant().getLiteral();
                if (uri.equals(OWLRDFVocabulary.RDFS_LABEL.getURI())) {
                    lo.setName(val);
                    isProcessed = true;
                }
            }
            if (!isProcessed) {
                for (MetadataMapping mapping : this.ioprofile.getMetadataMappings()) {
                    if (!mapping.translateOWLAxiom(axiom, lo, this)) continue;
                    isProcessed = true;
                }
            }
            if (isProcessed) continue;
            unprocessedAxioms.add(axiom);
        }
        for (OWLAnnotationAxiom axiom : unprocessedAxioms) {
            OWLAnnotation owlAnnot = axiom.getAnnotation();
            URI uri = owlAnnot.getAnnotationURI();
            String propid = this.getOboID(uri);
            OBOProperty prop = this.getOboProperty(propid);
            if (!(owlAnnot instanceof OWLConstantAnnotation)) continue;
            String val = owlAnnot.getAnnotationValueAsConstant().getLiteral();
            PropertyValueImpl pv = new PropertyValueImpl("property_value", propid + " " + val);
            lo.addPropertyValue(pv);
        }
    }

    public OBOProperty getOboProperty(OWLProperty owlProp) {
        String id = this.getOboID((OWLEntity)owlProp);
        return this.getOboProperty(id);
    }

    public OBOProperty getOboProperty(String id) {
        IdentifiedObject io = this.session.getObject(id);
        if (io == null) {
            return TermUtil.castToProperty(this.session.getObjectFactory().createDanglingObject(id, true));
        }
        return TermUtil.castToProperty(io);
    }

    public Instance getOboInstance(String id) {
        IdentifiedObject io = this.session.getObject(id);
        if (io == null) {
            return TermUtil.castToInstance(this.session.getObjectFactory().createDanglingObject(id, true));
        }
        return TermUtil.castToInstance((LinkedObject)io);
    }

    public OBOSession writeAll(OBOSession session, String file, OBOSerializationEngine.FilteredPath filteredPath) throws DataAdapterException {
        this.manager = OWLManager.createOWLOntologyManager();
        if (!file.contains("file:")) {
            file = "file:" + file;
        }
        URI physicalURI = URI.create(file);
        this.ontologyURI = URI.create("http://purl.org/obo/all");
        SimpleURIMapper mapper = new SimpleURIMapper(this.ontologyURI, physicalURI);
        this.manager.addURIMapper((OWLOntologyURIMapper)mapper);
        try {
            this.setProgressString("Writing file...");
            OWLOntology owlOntology = this.obo2owl(session, this.ontologyURI);
            this.manager.saveOntology(this.ontology, this.ioprofile.getOntologyFormat());
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAdapterException((Throwable)e, "Write error");
        }
    }

    public OWLOntology obo2owl(OBOSession session, URI ontologyURI) throws DataAdapterException {
        try {
            this.ontology = this.manager.createOntology(ontologyURI);
            this.owlFactory = this.manager.getOWLDataFactory();
            for (IdentifiedObject io : session.getObjects()) {
                if (!(io instanceof Annotation)) continue;
                Annotation a = (Annotation)io;
                Link link = a.getPositedLink();
            }
            for (IdentifiedObject io : session.getObjects()) {
                if (io.isBuiltIn()) continue;
                String id = io.getID();
                try {
                    if (io instanceof OBOClass) {
                        OBOClass oboClass = (OBOClass)io;
                        OWLClass owlClass = this.getOWLClass(io);
                        this.addOboMetadataToOwlEntity((OWLEntity)owlClass, io);
                        HashSet<OWLDescription> intersectionElements = new HashSet<OWLDescription>();
                        for (Link link : oboClass.getParents()) {
                            OWLClass owlParentClass = null;
                            try {
                                owlParentClass = this.getOWLClass(link.getParent());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (owlParentClass == null) continue;
                            OBOProperty oboProp = link.getType();
                            NestedValue nv = link.getNestedValue();
                            if (oboProp.equals(OBOProperty.DISJOINT_FROM)) {
                                HashSet<OWLClass> pair = new HashSet<OWLClass>();
                                pair.add(owlClass);
                                pair.add(owlParentClass);
                                this.addAxiom((OWLAxiom)this.owlFactory.getOWLDisjointClassesAxiom(pair));
                                continue;
                            }
                            LinkedList<Object> owlSuperClasses = new LinkedList<Object>();
                            if (oboProp.equals(OBOProperty.IS_A)) {
                                owlSuperClasses.add(owlParentClass);
                            } else {
                                OWLObjectProperty owlProp = this.getOWLObjectProperty(oboProp);
                                owlSuperClasses.add(this.owlFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)owlProp, (OWLDescription)owlParentClass));
                                if (oboProp.isUniversallyQuantified()) {
                                    owlSuperClasses.add(this.owlFactory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)owlProp, (OWLDescription)owlParentClass));
                                }
                            }
                            if (TermUtil.isIntersection(link)) {
                                for (OWLDescription oWLDescription : owlSuperClasses) {
                                    intersectionElements.add(oWLDescription);
                                }
                                continue;
                            }
                            for (OWLDescription oWLDescription : owlSuperClasses) {
                                OWLSubClassAxiom axiom = this.owlFactory.getOWLSubClassAxiom((OWLDescription)owlClass, oWLDescription);
                                AddAxiom addAxiom = new AddAxiom(this.ontology, (OWLAxiom)axiom);
                                this.manager.applyChange((OWLOntologyChange)addAxiom);
                                if (nv == null) continue;
                                Set<PropertyValue> pvs = nv.getPropertyValues();
                                for (PropertyValue pv : pvs) {
                                    OWLUntypedConstant con = this.owlFactory.getOWLUntypedConstant(pv.getValue());
                                    URI predURI = this.getURI(pv.getProperty());
                                    OWLConstantAnnotation owlAnnot = this.owlFactory.getOWLConstantAnnotation(predURI, (OWLConstant)con);
                                    OWLAxiomAnnotationAxiom aaa = this.owlFactory.getOWLAxiomAnnotationAxiom((OWLAxiom)axiom, (OWLAnnotation)owlAnnot);
                                    AddAxiom addAAA = new AddAxiom(this.ontology, (OWLAxiom)aaa);
                                    this.manager.applyChange((OWLOntologyChange)addAAA);
                                }
                            }
                        }
                        if (intersectionElements.size() <= 0) continue;
                        OWLObjectIntersectionOf owlIntersection = this.owlFactory.getOWLObjectIntersectionOf(intersectionElements);
                        HashSet<Object> pair = new HashSet<Object>();
                        pair.add(owlClass);
                        pair.add(owlIntersection);
                        OWLEquivalentClassesAxiom ecAxiom = this.owlFactory.getOWLEquivalentClassesAxiom(pair);
                        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)ecAxiom));
                        continue;
                    }
                    if (io instanceof OBOProperty) {
                        OBOProperty oboProp = (OBOProperty)io;
                        if (oboProp.isNonInheritable()) continue;
                        OWLObjectProperty owlProp = this.getOWLObjectProperty(io);
                        this.addOboMetadataToOwlEntity((OWLEntity)owlProp, io);
                        for (Link link : oboProp.getParents()) {
                            OWLObjectProperty owlParentProp = this.getOWLObjectProperty(link.getParent());
                            OBOProperty linkType = link.getType();
                            if (!linkType.equals(OBOProperty.IS_A)) continue;
                            this.addAxiom((OWLAxiom)this.owlFactory.getOWLSubObjectPropertyAxiom((OWLObjectPropertyExpression)owlProp, (OWLObjectPropertyExpression)owlParentProp));
                        }
                        if (oboProp.getTransitiveOver() != null) {
                            ArrayList<OWLObjectProperty> chain = new ArrayList<OWLObjectProperty>();
                            chain.add(owlProp);
                            chain.add(this.getOWLObjectProperty(oboProp.getTransitiveOver()));
                            OWLObjectPropertyChainSubPropertyAxiom ax = this.owlFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, (OWLObjectPropertyExpression)owlProp);
                            this.addAxiom((OWLAxiom)ax);
                        }
                        if (oboProp.getDomain() != null) {
                            this.addAxiom((OWLAxiom)this.owlFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)owlProp, (OWLDescription)this.getOWLClass(oboProp.getDomain())));
                        }
                        if (!oboProp.isTransitive()) continue;
                        this.addAxiom((OWLAxiom)this.owlFactory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)owlProp));
                        continue;
                    }
                    if (io instanceof Annotation) {
                        this.addOboAnnotation((Annotation)io);
                        continue;
                    }
                    if (!(io instanceof Instance)) continue;
                    this.addInstance((Instance)io);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    this.fireLossyWarning("problem with " + io.getID());
                }
            }
        }
        catch (OWLException e) {
            e.printStackTrace();
            throw new DataAdapterException((Throwable)e, "Write error");
        }
        return this.ontology;
    }

    public void addAxiom(OWLAxiom axiom) throws OWLOntologyChangeException {
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, axiom));
    }

    public void addOboMetadataToOwlEntity(OWLEntity owlEntity, IdentifiedObject io) throws OWLOntologyChangeException {
        if (io.getName() != null) {
            OWLUntypedConstant labelCon = this.owlFactory.getOWLUntypedConstant(io.getName());
            OWLConstantAnnotation anno = this.owlFactory.getOWLConstantAnnotation(OWLRDFVocabulary.RDFS_LABEL.getURI(), (OWLConstant)labelCon);
            this.addAxiom((OWLAxiom)this.owlFactory.getOWLEntityAnnotationAxiom(owlEntity, (OWLAnnotation)anno));
        }
        if (this.ioprofile != null && this.ioprofile.getMetadataMappings() != null) {
            for (MetadataMapping mapping : this.ioprofile.getMetadataMappings()) {
                for (OWLAxiom axiom : mapping.getOWLAxioms(this, owlEntity, io)) {
                    this.addAxiom(axiom);
                }
            }
        }
    }

    public void addOboAnnotation(Annotation oboAnnotation) throws OWLOntologyChangeException, DataAdapterException {
        this.addInstance(oboAnnotation);
        if (oboAnnotation.getSubject() != null) {
            this.addTriple((IdentifiedObject)oboAnnotation, "oban:has_subject", (IdentifiedObject)oboAnnotation.getSubject());
        }
        if (oboAnnotation.getRelationship() != null) {
            this.addTriple((IdentifiedObject)oboAnnotation, "oban:has_predicate", (IdentifiedObject)oboAnnotation.getRelationship());
        }
        if (oboAnnotation.getObject() != null) {
            this.addTriple((IdentifiedObject)oboAnnotation, "oban:has_object", (IdentifiedObject)oboAnnotation.getObject());
        }
    }

    public void addTriple(IdentifiedObject su, OBOProperty prop, IdentifiedObject ob) throws OWLOntologyChangeException, DataAdapterException {
        try {
            OWLIndividual owlSu = this.getOWLIndividual(su);
            OWLIndividual owlOb = this.getOWLIndividual(ob);
            OWLObjectProperty owlProp = this.getOWLObjectProperty(prop);
            this.addAxiom((OWLAxiom)this.owlFactory.getOWLObjectPropertyAssertionAxiom(owlSu, (OWLObjectPropertyExpression)owlProp, owlOb));
        }
        catch (UnsupportedEncodingException e) {
            this.fireLossyWarning("Cannot convert propertyId: ", prop);
        }
    }

    public void addTriple(IdentifiedObject su, String propId, IdentifiedObject ob) throws OWLOntologyChangeException, DataAdapterException {
        try {
            OWLIndividual owlSu = this.getOWLIndividual(su);
            OWLIndividual owlOb = this.getOWLIndividual(ob);
            OWLObjectProperty owlProp = this.getOWLObjectProperty(propId);
            this.addAxiom((OWLAxiom)this.owlFactory.getOWLObjectPropertyAssertionAxiom(owlSu, (OWLObjectPropertyExpression)owlProp, owlOb));
        }
        catch (UnsupportedEncodingException e) {
            this.fireLossyWarning("Cannot convert propertyId: " + propId);
        }
    }

    public void addInstance(Instance oboInst) throws OWLOntologyChangeException, DataAdapterException {
        try {
            OWLIndividual owlIndividual = this.getOWLIndividual(oboInst);
            if (oboInst.getType() != null) {
                try {
                    OWLClass owlClass = this.getOWLClass(oboInst.getType());
                    this.addAxiom((OWLAxiom)this.owlFactory.getOWLClassAssertionAxiom(owlIndividual, (OWLDescription)owlClass));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    this.fireLossyWarning("cannot convert to class");
                }
            }
            this.addOboMetadataToOwlEntity((OWLEntity)owlIndividual, oboInst);
            for (Link link : oboInst.getParents()) {
                if (link instanceof ValueLink) {
                    ValueLink vl = (ValueLink)link;
                    String message = "cannot handle value links (datatype properties) yet";
                    if (this.ioprofile.allowLossy) {
                        logger.info((Object)message);
                        continue;
                    }
                    throw new DataAdapterException(message + " -- set allowLossy to true to ignore this message");
                }
                this.addTriple((IdentifiedObject)oboInst, link.getType(), (IdentifiedObject)link.getParent());
            }
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            this.fireLossyWarning("cannot convert to class");
        }
    }

    public URI getURI(IdentifiedObject io) throws UnsupportedEncodingException {
        return this.getURI(io.getID());
    }

    public URI getURI(Dbxref x) throws UnsupportedEncodingException {
        return this.getURI(x.getDatabase() + ":" + x.getDatabaseID());
    }

    public URI getURI(String id) throws UnsupportedEncodingException {
        String localId;
        String db;
        if (id.contains(" ")) {
            throw new UnsupportedEncodingException();
        }
        String[] idParts = StringUtils.split((String)id, (String)":", (int)2);
        if (idParts.length > 1) {
            db = idParts[0];
            localId = idParts[1];
        } else if (idParts.length == 0) {
            db = "_global";
            localId = id;
        } else {
            db = "_global";
            localId = idParts[0];
        }
        if (db.equals("http")) {
            return URI.create(id);
        }
        IDSpaceRegistry registry = IDSpaceRegistry.getInstance();
        for (URI uriPrefix : registry.getUris()) {
            if (!db.equals(registry.getIDSpace(uriPrefix))) continue;
            String uriPrefixString = uriPrefix.toString();
            return URI.create(uriPrefixString + localId);
        }
        String safeId = URLEncoder.encode(localId, "US-ASCII");
        if (safeId.matches("^\\d.*")) {
            safeId = db + "_" + safeId;
        }
        if (safeId.contains(" ")) {
            safeId = safeId.replace(" ", "_");
        }
        URI uri = null;
        try {
            uri = URI.create(PURL_OBO_OWL + db + "#" + safeId);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedEncodingException();
        }
        return uri;
    }

    public OWLClass getOWLClass(IdentifiedObject io) throws UnsupportedEncodingException {
        return this.owlFactory.getOWLClass(this.getURI(io));
    }

    public OWLIndividual getOWLIndividual(IdentifiedObject io) throws UnsupportedEncodingException {
        URI uri = this.getURI(io);
        if (uri == null) {
            logger.info((Object)("no URI for " + io));
        }
        return this.owlFactory.getOWLIndividual(uri);
    }

    public OWLObjectProperty getOWLObjectProperty(IdentifiedObject io) throws UnsupportedEncodingException {
        return this.owlFactory.getOWLObjectProperty(this.getURI(io));
    }

    public OWLObjectProperty getOWLObjectProperty(String id) throws UnsupportedEncodingException {
        return this.owlFactory.getOWLObjectProperty(this.getURI(id));
    }

    public OWLDataFactory getOwlFactory() {
        return this.owlFactory;
    }

    public void setOwlFactory(OWLDataFactory owlFactory) {
        this.owlFactory = owlFactory;
    }

    public OBOSession getSession() {
        return this.session;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OWLAdapterConfiguration
    extends FileAdapterConfiguration {
        protected boolean allowDangling = false;
        protected boolean allowLossy = false;
        protected boolean failFast = false;
        protected boolean saveImplied;
        protected boolean combineOWLOntologies = true;
        protected List<OBOSerializationEngine.FilteredPath> saveRecords = new ArrayList<OBOSerializationEngine.FilteredPath>();
        protected boolean basicSave = true;
        protected String serializer = "OBO_1_0";
        protected String impliedType = "Save for presentation";
        protected OWLOntologyFormat ontologyFormat = new DefaultOntologyFormat();
        protected Set<MetadataMapping> metadataMappings = new HashSet<MetadataMapping>();

        public void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        public String getSerializer() {
            return this.serializer;
        }

        public boolean getBasicSave() {
            return this.basicSave;
        }

        public void setBasicSave(boolean basicSave) {
            this.basicSave = basicSave;
        }

        public List<OBOSerializationEngine.FilteredPath> getSaveRecords() {
            return this.saveRecords;
        }

        public void setSaveRecords(List<OBOSerializationEngine.FilteredPath> saveRecords) {
            if (saveRecords.contains(null)) {
                new Exception("Null save record added to profile").printStackTrace();
            }
            this.saveRecords = saveRecords;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean isAllowLossy() {
            return this.allowLossy;
        }

        public void setAllowLossy(boolean allowLossy) {
            this.allowLossy = allowLossy;
        }

        public boolean isCombineOWLOntologies() {
            return this.combineOWLOntologies;
        }

        public void setCombineOWLOntologies(boolean combineOWLOntologies) {
            this.combineOWLOntologies = combineOWLOntologies;
        }

        public Set<MetadataMapping> getMetadataMappings() {
            return this.metadataMappings;
        }

        public void setMetadataMappings(Set<MetadataMapping> metadataMappings) {
            this.metadataMappings = metadataMappings;
        }

        public void addMetadataMapping(MetadataMapping metadataMapping) {
            this.metadataMappings.add(metadataMapping);
        }

        public OWLOntologyFormat getOntologyFormat() {
            return this.ontologyFormat;
        }

        public void setOntologyFormat(OWLOntologyFormat ontologyFormat) {
            this.ontologyFormat = ontologyFormat;
        }

        public void setOntologyFormat(String owlFormat) throws DataAdapterException {
            if (owlFormat.equals("owlxml")) {
                this.ontologyFormat = new OWLXMLOntologyFormat();
            } else if (owlFormat.equals("owlfunctionalsyntax")) {
                this.ontologyFormat = new OWLFunctionalSyntaxOntologyFormat();
            } else if (owlFormat.equals("manchesterowlsyntax")) {
                this.ontologyFormat = new ManchesterOWLSyntaxOntologyFormat();
            } else if (owlFormat.equals("obo")) {
                this.ontologyFormat = new OBOOntologyFormat();
            } else if (owlFormat.equals("default") || owlFormat.equals("rdfxml")) {
                this.ontologyFormat = new RDFXMLOntologyFormat();
            } else {
                throw new DataAdapterException("invalid owl ontology format: " + owlFormat);
            }
        }
    }
}

