/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.datamodel.impl;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymedObject;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.impl.NCBOOboInOWLMetadataMapping;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomAnnotationBasedOWLMetadataMapping
extends NCBOOboInOWLMetadataMapping {
    protected static final Logger logger = Logger.getLogger(AxiomAnnotationBasedOWLMetadataMapping.class);

    @Override
    public boolean isOboToOWLLossy() {
        return true;
    }

    @Override
    public String getName() {
        return "Axiom annotation based mapping";
    }

    @Override
    public String getDesc() {
        return "The characteristic feature of this mapping is that it uses OWL1.1 AxiomAnnotationAxioms instead of the n-ary relation pattern to fully capture synonym and definition metadata. Unfortunately, these are currently lost in the RDFXML translation";
    }

    @Override
    public Set<OWLAxiom> getOWLAxioms(OWLAdapter adapter, OWLEntity owlEntity, IdentifiedObject io) {
        OWLAnnotationAxiom axiom;
        String def;
        String comment;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        this.setFactory(adapter.getOwlFactory());
        if (io instanceof CommentedObject && (comment = ((CommentedObject)io).getComment()) != null && !comment.equals("")) {
            axioms.add((OWLAxiom)this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_COMMENT.getURI(), comment));
        }
        if (io instanceof DefinedObject && (def = ((DefinedObject)io).getDefinition()) != null && !def.equals("")) {
            OWLAnnotationAxiom axiom2 = this.getAnnotationAxiom(owlEntity, this.getVocabURI("hasDefinition"), def);
            axioms.add((OWLAxiom)axiom2);
            for (Dbxref x : ((DefinedObject)io).getDefDbxrefs()) {
                try {
                    axioms.add((OWLAxiom)this.getAxiomAnnotationAxiom((OWLAxiom)axiom2, OWLRDFVocabulary.RDFS_SEE_ALSO.getURI(), adapter.getURI(x)));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        if (io instanceof SynonymedObject) {
            for (Synonym s : ((SynonymedObject)io).getSynonyms()) {
                axiom = this.getAnnotationAxiom(owlEntity, this.getVocabURI("hasSynonym"), s.getText());
                axioms.add((OWLAxiom)axiom);
                for (Dbxref x : s.getXrefs()) {
                    try {
                        axioms.add((OWLAxiom)this.getAxiomAnnotationAxiom((OWLAxiom)axiom, OWLRDFVocabulary.RDFS_SEE_ALSO.getURI(), adapter.getURI(x)));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (io instanceof DbxrefedObject) {
            for (Dbxref x : ((DbxrefedObject)((Object)io)).getDbxrefs()) {
                try {
                    axiom = this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_SEE_ALSO.getURI(), adapter.getURI(x));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return axioms;
    }

    @Override
    public boolean translateOWLAxiom(OWLAnnotationAxiom axiom, IdentifiedObject lo, OWLAdapter adapter) {
        return false;
    }
}

