/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.test;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.dataadapter.OBOAdapter;
import org.obo.datamodel.OBOSession;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.MetadataMapping;
import org.obo.owl.datamodel.impl.SimpleOWLMetadataMapping;
import org.obo.owl.test.AllOWLTests;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.test.AbstractOBOTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLTest
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(AllOWLTests.class);

    protected boolean isSourceOWL() {
        return false;
    }

    protected boolean isCombineOWLOntologies() {
        return false;
    }

    protected boolean isAllowLossyWhenWritingOWL() {
        return false;
    }

    protected boolean isAllowLossyWhenReadingOWL() {
        return false;
    }

    protected AbstractOWLTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        logger.info((Object)("Setting up: " + (Object)((Object)this)));
        ForwardChainingReasoner.checkRecache = false;
        this.session = this.getSessionFromResources(this.getFilesToLoad());
    }

    @Override
    protected OBOSession getSessionFromResources(Collection<String> names) throws DataAdapterException {
        if (!this.isSourceOWL()) {
            return super.getSessionFromResources(names);
        }
        this.readOWLFiles(names);
        return this.session;
    }

    public void testHasLoaded() throws IOException, DataAdapterException {
        if (this.isSourceOWL()) {
            File outFile = this.writeTempOBOFile();
            this.readOBOFile(outFile);
            this.writeTempOWLFile();
        } else {
            File outFile = this.writeTempOWLFile();
            this.readOWLFile(outFile);
            this.writeTempOBOFile();
        }
    }

    public File writeTempOWLFile() throws IOException, DataAdapterException {
        return this.writeTempOWLFile(new SimpleOWLMetadataMapping());
    }

    public File writeTempOWLFile(MetadataMapping mapping) throws IOException, DataAdapterException {
        OWLAdapter adapter = new OWLAdapter();
        OWLAdapter.OWLAdapterConfiguration config = new OWLAdapter.OWLAdapterConfiguration();
        config.addMetadataMapping(mapping);
        if (this.isAllowLossyWhenWritingOWL()) {
            config.setAllowLossy(true);
        }
        File outFile = new File("file:///tmp/foo.owl");
        config.setWritePath(outFile.toString());
        adapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)config, this.session);
        return outFile;
    }

    public void readOWLFile(File file) throws DataAdapterException {
        this.readOWLFiles(Collections.singleton(file.toString()));
    }

    public void readOWLFiles(Collection<String> files) throws DataAdapterException {
        OWLAdapter adapter = new OWLAdapter();
        OWLAdapter.OWLAdapterConfiguration config = new OWLAdapter.OWLAdapterConfiguration();
        this.addMappings(config);
        config.getReadPaths().addAll(files);
        config.setAllowLossy(this.isAllowLossyWhenReadingOWL());
        config.setCombineOWLOntologies(this.isCombineOWLOntologies());
        this.session = adapter.doOperation(OWLAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    protected void addMappings(OWLAdapter.OWLAdapterConfiguration config) {
        config.addMetadataMapping(new SimpleOWLMetadataMapping());
    }
}

