/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.owl.datamodel.impl.NCBOOboInOWLMetadataMapping;
import org.obo.owl.test.AbstractOWLTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitiveOverOWLTest
extends AbstractOWLTest {
    protected static final Logger logger = Logger.getLogger(TransitiveOverOWLTest.class);

    public TransitiveOverOWLTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"regulation_of_transcription_xp.obo"};
        return Arrays.asList(files);
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        TransitiveOverOWLTest.addTests(suite);
        return suite;
    }

    public void testLinks() throws Exception {
        this.testForTransitiveOver("negatively_regulates", "part_of");
    }

    @Override
    public void testHasLoaded() throws IOException, DataAdapterException {
        File outFile = this.writeTempOWLFile(new NCBOOboInOWLMetadataMapping());
        this.readOWLFile(outFile);
        this.writeTempOBOFile();
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new TransitiveOverOWLTest("testHasLoaded"));
        suite.addTest((Test)new TransitiveOverOWLTest("testLinks"));
    }
}

