/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.util;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDSpaceRegistry {
    protected static final Logger logger = Logger.getLogger(IDSpaceRegistry.class);
    private static IDSpaceRegistry instance;
    private Map<URI, String> uriToIDSpace = new HashMap<URI, String>();

    private IDSpaceRegistry() {
        this.registerMapping("http://www.ifomis.org/bfo/1.1#", "bfo_1_1");
        this.registerMapping("http://www.ifomis.org/bfo/1.0#", "bfo_1_0");
        this.registerMapping("http://purl.org/biotop/dev#", "biotop_dev");
        this.registerMapping("http://ccdb.ucsd.edu/SAO/1.2#", "sao");
        this.registerMapping("http://obi.sourceforge.net/ontology/OBI.owl#", "obi");
        this.registerMapping("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
    }

    public static synchronized IDSpaceRegistry getInstance() {
        if (instance == null) {
            instance = new IDSpaceRegistry();
        }
        return instance;
    }

    public void clearuriToIDSpace() {
        this.uriToIDSpace.clear();
    }

    public Map<URI, String> getUriToIDSpace() {
        return this.uriToIDSpace;
    }

    public String getIDSpace(URI uriPrefix) {
        return this.uriToIDSpace.get(uriPrefix);
    }

    public Collection<URI> getUris() {
        return this.uriToIDSpace.keySet();
    }

    public void registerMapping(String prefix, String idSpace) {
        this.uriToIDSpace.put(URI.create(prefix), idSpace);
    }

    public void registerMapping(URI uriPrefix, String idSpace) {
        this.uriToIDSpace.put(uriPrefix, idSpace);
    }

    public void unregisterMapping(URI uriPrefix) {
        this.uriToIDSpace.remove(uriPrefix);
    }
}

