/*
 * Decompiled with CFR 0.152.
 */
package org.obo.postcomp;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiableObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.DanglingObjectImpl;
import org.obo.datamodel.impl.DanglingPropertyImpl;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.NameChangeHistoryItem;
import org.obo.history.OperationModel;
import org.obo.history.TermMacroHistoryItem;
import org.obo.postcomp.ASTCompoundExpression;
import org.obo.postcomp.ASTDifferentiaExpression;
import org.obo.postcomp.ASTGenusExpression;
import org.obo.postcomp.ASTIdentifier;
import org.obo.postcomp.ASTPostcompExpression;
import org.obo.postcomp.DefaultTypeNameProvider;
import org.obo.postcomp.Node;
import org.obo.postcomp.OBOPostcomp;
import org.obo.postcomp.ParseException;
import org.obo.postcomp.TypeNameProvider;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostcompUtil {
    protected static final Logger logger = Logger.getLogger(PostcompUtil.class);
    protected static final Comparator<Link> intersectionComparator = new Comparator<Link>(){

        @Override
        public int compare(Link o1, Link o2) {
            if (!o1.getType().equals(o2.getType())) {
                if (o1.getType().equals(OBOProperty.IS_A)) {
                    return -1;
                }
                if (o2.getType().equals(OBOProperty.IS_A)) {
                    return 1;
                }
                return o1.getType().getID().compareToIgnoreCase(o2.getType().getID());
            }
            return o1.getParent().getID().compareToIgnoreCase(o2.getParent().getID());
        }
    };
    protected static Comparator<String[]> defReqComparator = new Comparator<String[]>(){

        @Override
        public int compare(String[] a, String[] b) {
            int compVal = a[0].compareToIgnoreCase(b[0]);
            if (compVal != 0) {
                if (a[0].equals(OBOProperty.IS_A.getID())) {
                    return -1;
                }
                if (a[1].equals(OBOProperty.IS_A.getID())) {
                    return 1;
                }
                return compVal;
            }
            return a[1].compareToIgnoreCase(b[1]);
        }
    };
    protected static TypeNameProvider defaultProvider;

    public static OBOClass createPostcompObject(OBOSession session, String exp) throws ParseException {
        return PostcompUtil.createPostcompObject(session, exp, null, false);
    }

    public static OBOClass createPostcompObject(OBOSession session, String exp, TypeNameProvider provider, boolean allowDangling) throws ParseException {
        OperationModel model = session.getOperationModel();
        model.setSession(session);
        HistoryItem item = PostcompUtil.createPostcompItem(session, exp, provider, allowDangling);
        model.apply(item);
        OBOClass out = (OBOClass)session.getObject(item.getTarget());
        return out;
    }

    public static OBOClass createPostcompObject(OBOSession session, String exp, boolean allowDangling) throws ParseException {
        return PostcompUtil.createPostcompObject(session, exp, null, allowDangling);
    }

    public static HistoryItem createPostcompItem(OBOSession session, String exp, TypeNameProvider provider, boolean allowDangling) throws ParseException {
        return PostcompUtil.createPostcompItem(session, exp, new HashMap<OBOClass, Collection<Link>>(), provider, allowDangling);
    }

    public static HistoryItem createPostcompItem(OBOSession session, String exp, boolean allowDangling) throws ParseException {
        return PostcompUtil.createPostcompItem(session, exp, new HashMap<OBOClass, Collection<Link>>(), null, allowDangling);
    }

    public static HistoryItem createPostcompItem(OBOSession session, String exp, Map<OBOClass, Collection<Link>> intersectionMap, TypeNameProvider provider, boolean allowDangling) throws ParseException {
        OBOPostcomp t = new OBOPostcomp(new StringReader(exp));
        ASTPostcompExpression expression = (ASTPostcompExpression)t.PostcompExpression();
        TermMacroHistoryItem item = new TermMacroHistoryItem();
        for (IdentifiedObject io : session.getObjects()) {
            if (!(io instanceof OBOClass)) continue;
            OBOClass oboClass = (OBOClass)io;
            LinkedList<Link> intersections = null;
            for (Link link : oboClass.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                if (intersections == null) {
                    intersections = new LinkedList<Link>();
                    intersectionMap.put(oboClass, intersections);
                }
                intersections.add(link);
            }
        }
        String id = PostcompUtil.createPostcompItem(item, intersectionMap, session, (ASTCompoundExpression)expression.jjtGetChild(0), provider, allowDangling);
        item.setTarget(id);
        return item;
    }

    protected static String createPostcompItem(TermMacroHistoryItem item, Map<OBOClass, Collection<Link>> intersectionMap, OBOSession session, ASTCompoundExpression node, TypeNameProvider provider, boolean allowDangling) throws ParseException {
        LinkedList<String[]> defReqs = new LinkedList<String[]>();
        for (Node n : node.children) {
            if (n instanceof ASTGenusExpression) {
                String[] pair = new String[]{OBOProperty.IS_A.getID(), PostcompUtil.getIdentifier((ASTGenusExpression)n)};
                defReqs.add(pair);
                continue;
            }
            if (n instanceof ASTDifferentiaExpression) {
                String typeID = PostcompUtil.getTypeIdentifier((ASTDifferentiaExpression)n);
                ASTCompoundExpression target = PostcompUtil.getDiffTarget((ASTDifferentiaExpression)n);
                String targetID = PostcompUtil.createPostcompItem(item, intersectionMap, session, target, provider, allowDangling);
                String[] pair = new String[]{typeID, targetID};
                defReqs.add(pair);
                continue;
            }
            if (!(n instanceof ASTCompoundExpression)) continue;
            String id = PostcompUtil.createPostcompItem(item, intersectionMap, session, (ASTCompoundExpression)n, provider, allowDangling);
            String[] pair = new String[]{OBOProperty.IS_A.getID(), id};
            defReqs.add(pair);
        }
        if (defReqs.size() == 1 && ((String[])defReqs.get(0))[0].equals(OBOProperty.IS_A.getID())) {
            return ((String[])defReqs.get(0))[1];
        }
        Collections.sort(defReqs, defReqComparator);
        IdentifiableObject classMatch = null;
        for (OBOClass oboClass : intersectionMap.keySet()) {
            Collection<Link> links = intersectionMap.get(oboClass);
            LinkedList defReqsCopy = new LinkedList(defReqs);
            boolean foundAll = true;
            for (Link link : links) {
                String[] match = null;
                for (String[] pair : defReqsCopy) {
                    if (!link.getType().getID().equals(pair[0]) || !link.getParent().getID().equals(pair[1])) continue;
                    match = pair;
                    break;
                }
                if (match == null) {
                    foundAll = false;
                    break;
                }
                defReqsCopy.remove(match);
            }
            if (!foundAll || defReqsCopy.size() != 0) continue;
            classMatch = oboClass;
            break;
        }
        if (classMatch != null) {
            return classMatch.getID();
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String[] temp : defReqs) {
            if (!first) {
                buffer.append("^");
            }
            if (temp[0].equals(OBOProperty.IS_A.getID())) {
                buffer.append(temp[1]);
            } else {
                buffer.append(temp[0]);
                buffer.append('(');
                buffer.append(temp[1]);
                buffer.append(')');
            }
            first = false;
        }
        String newID = buffer.toString();
        item.addItem(new CreateObjectHistoryItem(newID, true, OBOClass.OBO_CLASS.getID()));
        OBOClass oboClass = (OBOClass)session.getObjectFactory().createObject(newID, OBOClass.OBO_CLASS, true);
        LinkedList<OBORestriction> links = new LinkedList<OBORestriction>();
        for (String[] temp : defReqs) {
            OBOProperty type;
            OBOClass parent = PostcompUtil.getObject(temp[1], session, intersectionMap);
            if (parent == null) {
                if (allowDangling) {
                    parent = new DanglingObjectImpl(temp[1]);
                } else {
                    throw new ParseException("Cannot resolve term id " + temp[1]);
                }
            }
            if ((type = (OBOProperty)session.getObject(temp[0])) == null) {
                if (allowDangling) {
                    type = new DanglingPropertyImpl(temp[0]);
                } else {
                    throw new ParseException("Cannot resolve type id " + temp[0]);
                }
            }
            OBORestriction link = session.getObjectFactory().createOBORestriction(oboClass, type, parent, false);
            link.setCompletes(true);
            item.addItem(new CreateLinkHistoryItem(oboClass.getID(), temp[0], temp[1]));
            item.addItem(new CompletesHistoryItem(oboClass.getID(), temp[0], temp[1], false));
            links.add(link);
            oboClass.atomicAddParent(link);
        }
        intersectionMap.put(oboClass, links);
        String name = PostcompUtil.getPostcompName(oboClass, provider);
        oboClass.setName(name);
        item.addItem(new NameChangeHistoryItem(name, newID, newID));
        return newID;
    }

    protected static OBOClass getObject(String id, OBOSession session, Map<OBOClass, Collection<Link>> map) {
        OBOClass oboClass = (OBOClass)session.getObject(id);
        if (oboClass != null) {
            return oboClass;
        }
        for (OBOClass temp : map.keySet()) {
            if (!temp.getID().equals(id)) continue;
            return temp;
        }
        return null;
    }

    protected static String getIdentifier(ASTGenusExpression node) {
        return ((ASTIdentifier)node.jjtGetChild((int)0)).val;
    }

    protected static String getTypeIdentifier(ASTDifferentiaExpression node) {
        return ((ASTIdentifier)node.jjtGetChild((int)0)).val;
    }

    protected static ASTCompoundExpression getDiffTarget(ASTDifferentiaExpression node) {
        return (ASTCompoundExpression)node.jjtGetChild(1);
    }

    public static String getPostcompID(IdentifiedObject io) {
        return PostcompUtil.getPostcompID(io, false);
    }

    public static String getPostcompID(IdentifiedObject io, boolean alwaysDecompose) {
        if (PostcompUtil.isPostcompable(io, alwaysDecompose)) {
            OBOClass oboClass = (OBOClass)io;
            ArrayList<Link> links = new ArrayList<Link>();
            for (Link link : oboClass.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                links.add(link);
            }
            Collections.sort(links, intersectionComparator);
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (Link link : links) {
                if (!first) {
                    buffer.append('^');
                }
                if (link.getType().equals(OBOProperty.IS_A)) {
                    if (PostcompUtil.isPostcompable(link.getParent(), alwaysDecompose)) {
                        buffer.append('(');
                        buffer.append(PostcompUtil.getPostcompID(link.getParent(), alwaysDecompose));
                        buffer.append(')');
                    } else {
                        buffer.append(link.getParent().getID());
                    }
                } else {
                    buffer.append(link.getType().getID());
                    buffer.append('(');
                    buffer.append(PostcompUtil.getPostcompID(link.getParent(), alwaysDecompose));
                    buffer.append(')');
                }
                first = false;
            }
            return buffer.toString();
        }
        return io.getID();
    }

    public static String getNameExpression(IdentifiedObject io, boolean alwaysDecompose) {
        if (PostcompUtil.isPostcompable(io, alwaysDecompose)) {
            OBOClass oboClass = (OBOClass)io;
            ArrayList<Link> links = new ArrayList<Link>();
            for (Link link : oboClass.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                links.add(link);
            }
            Collections.sort(links, intersectionComparator);
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (Link link : links) {
                if (!first) {
                    buffer.append('^');
                }
                PostcompUtil.updateNameExpBuffer(buffer, link, alwaysDecompose);
                first = false;
            }
            return buffer.toString();
        }
        return io.getName();
    }

    public static String getNameExpression(Collection<Link> linksIn, boolean alwaysDecompose) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(linksIn);
        Collections.sort(links, intersectionComparator);
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Link link : links) {
            if (!first) {
                buffer.append('^');
            }
            PostcompUtil.updateNameExpBuffer(buffer, link, alwaysDecompose);
            first = false;
        }
        return buffer.toString();
    }

    protected static void updateNameExpBuffer(StringBuffer buffer, Link link, boolean alwaysDecompose) {
        if (link.getType().equals(OBOProperty.IS_A)) {
            if (PostcompUtil.isPostcompable(link.getParent(), alwaysDecompose)) {
                buffer.append('(');
                buffer.append(PostcompUtil.getNameExpression(link.getParent(), alwaysDecompose));
                buffer.append(')');
            } else {
                buffer.append(link.getParent().getName());
            }
        } else {
            buffer.append(link.getType().getID());
            buffer.append('(');
            buffer.append(PostcompUtil.getNameExpression(link.getParent(), alwaysDecompose));
            buffer.append(')');
        }
    }

    protected static TypeNameProvider getDefaultProvider() {
        if (defaultProvider == null) {
            defaultProvider = new DefaultTypeNameProvider();
        }
        return defaultProvider;
    }

    public static String getPostcompName(IdentifiedObject io, TypeNameProvider provider) {
        return PostcompUtil.getPostcompName(io, provider, false);
    }

    public static String getPostcompName(IdentifiedObject io, TypeNameProvider provider, boolean alwaysDecompose) {
        if (PostcompUtil.isPostcompable(io, alwaysDecompose)) {
            if (provider == null) {
                provider = PostcompUtil.getDefaultProvider();
            }
            OBOClass oboClass = (OBOClass)io;
            ArrayList<Link> links = new ArrayList<Link>();
            for (Link link : oboClass.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                links.add(link);
            }
            boolean nameable = false;
            for (Link link : links) {
                if (link.getParent().getName() == null) continue;
                nameable = true;
                break;
            }
            if (!nameable) {
                return null;
            }
            Collections.sort(links, intersectionComparator);
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (Link link : links) {
                if (!first) {
                    buffer.append(" that ");
                }
                PostcompUtil.updatePostcompNameBuffer(buffer, link, alwaysDecompose, provider, first);
                first = false;
            }
            return buffer.toString();
        }
        return io.getName() == null ? io.getName() : io.getID();
    }

    public static String getPostcompName(Collection<Link> linksIn, TypeNameProvider provider, boolean alwaysDecompose) {
        if (provider == null) {
            provider = PostcompUtil.getDefaultProvider();
        }
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(linksIn);
        Collections.sort(links, intersectionComparator);
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Link link : links) {
            if (!first) {
                buffer.append(" that ");
            }
            PostcompUtil.updatePostcompNameBuffer(buffer, link, alwaysDecompose, provider, first);
            first = false;
        }
        return buffer.toString();
    }

    protected static void updatePostcompNameBuffer(StringBuffer buffer, Link link, boolean alwaysDecompose, TypeNameProvider provider, boolean first) {
        if (link.getType().equals(OBOProperty.IS_A)) {
            if (!first) {
                buffer.append(" is a ");
            }
            if (PostcompUtil.isPostcompable(link.getParent(), alwaysDecompose)) {
                buffer.append(PostcompUtil.getPostcompName(link.getParent(), provider, alwaysDecompose));
            } else {
                buffer.append(link.getParent().getName());
            }
        } else {
            buffer.append(provider.getName(link.getType()));
            buffer.append(' ');
            buffer.append(PostcompUtil.getPostcompName(link.getParent(), provider, alwaysDecompose));
        }
    }

    protected static boolean isPostcompable(IdentifiedObject io, boolean alwaysDecompose) {
        if (alwaysDecompose) {
            return io instanceof LinkedObject && TermUtil.isIntersection((LinkedObject)io);
        }
        return PostcompUtil.isPostcompable(io);
    }

    public static boolean isPostcompable(IdentifiedObject io) {
        if (io.isAnonymous() && io instanceof OBOClass) {
            OBOClass oboClass = (OBOClass)io;
            int intersectionCount = 0;
            for (Link link : oboClass.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                ++intersectionCount;
            }
            if (intersectionCount > 0 && intersectionCount == oboClass.getParents().size()) {
                return true;
            }
        }
        return false;
    }
}

