/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.TaskDelegate;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.OBOSession;
import org.obo.query.Query;
import org.obo.query.QueryResolver;
import org.obo.query.impl.CachingQueryResolver;
import org.obo.query.impl.DefaultQueryResolver;
import org.obo.util.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEngine
extends CachingQueryResolver {
    protected static final Logger logger = Logger.getLogger(QueryEngine.class);
    protected OBOSession session;
    protected List<QueryResolver> queryResolvers = new LinkedList<QueryResolver>();

    public QueryEngine(OBOSession session) {
        this.setSession(session);
    }

    public OBOSession getSession() {
        return this.session;
    }

    public void addQueryResolver(QueryResolver queryResolver) {
        this.queryResolvers.add(queryResolver);
    }

    public void removeQueryResolver(QueryResolver queryResolver) {
        this.queryResolvers.remove(queryResolver);
    }

    public void setSession(OBOSession session) {
        if (this.session != null && session.getQueryResolver() != null) {
            this.removeQueryResolver(session.getQueryResolver());
        }
        this.session = session;
        if (session.getQueryResolver() != null) {
            this.queryResolvers.add(0, session.getQueryResolver());
        }
    }

    public <T, V> Collection<V> query(Query<T, V> q) {
        return this.query(q, false);
    }

    public <T, V> Collection<V> query(Query<T, V> q, boolean cache) {
        return QueryUtil.getResults(this.query(this.session.getLinkDatabase(), q, cache));
    }

    protected QueryResolver getResolver(Query q) {
        for (QueryResolver resolver : this.queryResolvers) {
            if (!resolver.wantsQuery(q)) continue;
            return resolver;
        }
        return DefaultQueryResolver.getResolver();
    }

    @Override
    public <T, V> TaskDelegate<Collection<V>> query(LinkDatabase linkDatabase, Query<T, V> q) {
        QueryResolver resolver = this.getResolver(q);
        return resolver.query(linkDatabase, q);
    }

    @Override
    public <T, V> TaskDelegate<Collection<V>> query(Collection<? extends T> objects, Query<T, V> q) {
        QueryResolver resolver = this.getResolver(q);
        return resolver.query(objects, q);
    }

    @Override
    public <T, V> TaskDelegate<Collection<V>> subquery(Collection<? extends V> objects, Query<T, V> q) {
        QueryResolver resolver = this.getResolver(q);
        return resolver.subquery(objects, q);
    }

    public boolean wantsQuery(Query q) {
        return true;
    }
}

