/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.AbstractTaskDelegate;
import org.bbop.util.TaskDelegate;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.LinkDatabase;
import org.obo.filters.SearchCriterion;
import org.obo.query.Query;
import org.obo.query.QueryResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueryResolver
implements QueryResolver {
    protected static final Logger logger = Logger.getLogger(DefaultQueryResolver.class);
    public static DefaultQueryResolver resolver;

    public static QueryResolver getResolver() {
        if (resolver == null) {
            resolver = new DefaultQueryResolver();
        }
        return resolver;
    }

    public boolean wantsQuery(Query q) {
        return true;
    }

    protected boolean queryMightAccept(Query q, Class<?> c) {
        boolean might = c.isAssignableFrom(q.getInputType()) || this.queryAccepts(q, c);
        return might;
    }

    protected boolean queryAccepts(Query q, Class<?> c) {
        Class inputType = q.getInputType();
        boolean isAssignable = inputType.isAssignableFrom(c);
        return isAssignable;
    }

    @Override
    public <T, V> TaskDelegate<Collection<V>> query(final LinkDatabase linkDatabase, final Query<T, V> q) {
        AbstractTaskDelegate out = new AbstractTaskDelegate<Collection<V>>(){

            public void execute() {
                try {
                    Collection out;
                    long time = System.currentTimeMillis();
                    logger.info((Object)("Starting search: " + q));
                    this.progressString = "Querying...";
                    this.results = out = DefaultQueryResolver.this.getResultHolder(q);
                    Collection<FieldPathSpec> specs = q.getInputPaths();
                    if (specs == null) {
                        specs = new LinkedList<FieldPathSpec>();
                        specs.add(new FieldPathSpec(new SearchCriterion[0]));
                    }
                    LinkedList<FieldPath> paths = new LinkedList<FieldPath>();
                    for (FieldPathSpec spec : specs) {
                        FieldPath qpath = FieldPathSpec.createQueryPath(spec);
                        if (this.cancelled) {
                            return;
                        }
                        Collection<FieldPath> values = FieldPath.resolve(qpath, linkDatabase);
                        for (FieldPath p : values) {
                            if (!DefaultQueryResolver.this.queryAccepts(q, p.getLastValue().getClass()) || p.getObject().isBuiltIn()) continue;
                            paths.add(p);
                        }
                    }
                    int total = paths.size();
                    int i = 0;
                    for (FieldPath path : paths) {
                        Object r;
                        this.progress = new Integer(100 * i / total);
                        if (this.cancelled) {
                            return;
                        }
                        Object vgg = path.getLastValue();
                        q.setFieldPath(path);
                        Object result = r = q.matches(vgg);
                        if (result != null) {
                            out.add(result);
                        }
                        ++i;
                    }
                    if (out instanceof List && q.getComparator() != null) {
                        Collections.sort((List)out, q.getComparator());
                    }
                    logger.info((Object)("Finished search, found " + out.size() + " results in " + (System.currentTimeMillis() - time) + "" + " ms"));
                    this.results = out;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        return out;
    }

    @Override
    public <T, V> TaskDelegate<Collection<V>> query(final Collection<? extends T> objects, final Query<T, V> q) {
        AbstractTaskDelegate out = new AbstractTaskDelegate<Collection<V>>(){

            public void execute() {
                long time = System.currentTimeMillis();
                this.progressString = "Querying...";
                Collection out = DefaultQueryResolver.this.getResultHolder(q);
                int i = 0;
                for (Object o : objects) {
                    if (this.cancelled) {
                        return;
                    }
                    Object result = q.matches(o);
                    this.progress = new Integer(100 * i / objects.size());
                    if (result != null) {
                        out.add(result);
                    }
                    ++i;
                }
                if (out instanceof List && q.getComparator() != null) {
                    Collections.sort((List)out, q.getComparator());
                }
                this.results = out;
            }
        };
        return out;
    }

    @Override
    public <T, V> TaskDelegate<Collection<V>> subquery(final Collection<? extends V> objects, final Query<T, V> q) {
        AbstractTaskDelegate out = new AbstractTaskDelegate<Collection<V>>(){

            public void execute() {
                Collection out = DefaultQueryResolver.this.getResultHolder(q);
                for (Object o : objects) {
                    Object result = q.matches(q.convertToInputType(o));
                    if (result == null) continue;
                    out.add(result);
                }
                if (out instanceof List && q.getComparator() != null) {
                    Collections.sort((List)out, q.getComparator());
                }
                this.results = out;
            }
        };
        return out;
    }

    public <T, V> Collection<V> getResultHolder(Query<T, V> q) {
        Collection<V> out = q.createResultHolder();
        if (out == null) {
            out = new ArrayList<V>();
        }
        return out;
    }
}

