/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Synonym;
import org.obo.filters.NameSearchCriterion;
import org.obo.filters.SearchCriterion;
import org.obo.filters.StringConverter;
import org.obo.filters.StringCriterionWrapper;
import org.obo.filters.SynonymSearchCriterion;
import org.obo.query.StringQuery;
import org.obo.query.impl.ScoredCriterionHit;
import org.obo.query.impl.ScoredQueryHit;
import org.obo.query.impl.ScoredStringHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoredCriterionQuery
implements StringQuery<IdentifiedObject, ScoredQueryHit> {
    protected static final Logger logger = Logger.getLogger(ScoredCriterionQuery.class);
    protected List<SearchCriterion<IdentifiedObject, String>> searchCriteria = new LinkedList<SearchCriterion<IdentifiedObject, String>>();
    protected Map<SearchCriterion<IdentifiedObject, String>, Double> weightMap = new HashMap<SearchCriterion<IdentifiedObject, String>, Double>();
    protected boolean ignoreCase = true;
    protected Collection<String> searchWords;
    protected String searchString;
    protected Comparator<SearchCriterion<IdentifiedObject, String>> weightComparator = new Comparator<SearchCriterion<IdentifiedObject, String>>(){

        @Override
        public int compare(SearchCriterion<IdentifiedObject, String> o1, SearchCriterion<IdentifiedObject, String> o2) {
            return (int)(ScoredCriterionQuery.this.getWeight(o2) - ScoredCriterionQuery.this.getWeight(o1));
        }
    };

    public ScoredCriterionQuery(boolean useDefaults) {
        if (useDefaults) {
            this.populateDefaults();
        }
    }

    protected void populateDefaults() {
        this.addCriterion(new NameSearchCriterion(), 100.0);
        this.addCriterion(new StringCriterionWrapper<IdentifiedObject, Synonym>(new SynonymSearchCriterion(), StringConverter.DEFAULT), 1.0);
    }

    public void clear() {
        this.searchCriteria.clear();
        this.weightMap.clear();
    }

    public void addCriterion(SearchCriterion<IdentifiedObject, String> criterion) {
        this.addCriterion(criterion, 1.0);
    }

    public void addCriterion(SearchCriterion<IdentifiedObject, String> criterion, Double weight) {
        this.searchCriteria.add(criterion);
        this.weightMap.put(criterion, weight);
    }

    public double getWeight(SearchCriterion<IdentifiedObject, String> criterion) {
        Double d = this.weightMap.get(criterion);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public IdentifiedObject convertToInputType(ScoredQueryHit original) {
        return (IdentifiedObject)original.getHit();
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void setSearchString(String searchString) {
        this.searchWords = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(searchString);
        while (tokenizer.hasMoreTokens()) {
            this.searchWords.add(tokenizer.nextToken());
        }
        this.searchString = searchString;
    }

    public String getString(String s) {
        if (this.ignoreCase) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public ScoredQueryHit matches(IdentifiedObject a) {
        ScoredQueryHit scoredQueryHit = null;
        LinkedList hits = new LinkedList();
        LinkedList scratch = new LinkedList();
        double score = 0.0;
        for (SearchCriterion<IdentifiedObject, String> criterion : this.searchCriteria) {
            scratch.clear();
            criterion.getValues(scratch, a);
            ScoredCriterionHit scoredCriterionHit = null;
            boolean failed = false;
            for (String s : scratch) {
                s = this.getString(s);
                for (String searchWord : this.searchWords) {
                    int pos = this.getString(s).indexOf(this.getString(searchWord));
                    double wordscore = ScoredCriterionQuery.getMatchPosScore(pos, s);
                    if (wordscore > 0.0) {
                        ScoredStringHit scoredStringHit = new ScoredStringHit(searchWord, s, wordscore, pos);
                        if (scoredCriterionHit == null) {
                            scoredCriterionHit = new ScoredCriterionHit(criterion, this.weightMap.get(criterion), s);
                        }
                        scoredCriterionHit.addStringHit(scoredStringHit);
                        continue;
                    }
                    failed = true;
                    break;
                }
                if (!failed) continue;
                scoredCriterionHit = null;
                break;
            }
            if (scoredCriterionHit == null) continue;
            if (scoredQueryHit == null) {
                scoredQueryHit = new ScoredQueryHit(a);
            }
            scoredQueryHit.addCriterionHit(scoredCriterionHit);
        }
        return scoredQueryHit;
    }

    protected static int getMatchPosScore(int index, String str) {
        if (index >= 0) {
            if (index == 0) {
                return 10;
            }
            if (Character.isWhitespace(str.charAt(index - 1))) {
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public Collection<SearchCriterion<IdentifiedObject, String>> getCriteria() {
        return this.searchCriteria;
    }

    @Override
    public Comparator<ScoredQueryHit> getComparator() {
        return ScoredQueryHit.COMPARATOR;
    }

    @Override
    public Collection<ScoredQueryHit> createResultHolder() {
        return new ArrayList<ScoredQueryHit>();
    }

    @Override
    public Class<IdentifiedObject> getInputType() {
        return IdentifiedObject.class;
    }

    @Override
    public ScoredQueryHit convertToOutputType(IdentifiedObject original) {
        ScoredStringHit strHit = new ScoredStringHit(original.getName(), original.getName(), Double.MAX_VALUE, 0);
        ScoredCriterionHit scHit = new ScoredCriterionHit(new NameSearchCriterion(), 1.0, original.getName());
        scHit.addStringHit(strHit);
        ScoredQueryHit hit = new ScoredQueryHit(original);
        hit.addCriterionHit(scHit);
        return hit;
    }

    public Comparator<SearchCriterion<IdentifiedObject, String>> getWeightComparator() {
        return this.weightComparator;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        LinkedList<FieldPathSpec> specs = new LinkedList<FieldPathSpec>();
        for (SearchCriterion<IdentifiedObject, String> sc : this.searchCriteria) {
            FieldPathSpec spec = new FieldPathSpec(sc);
            specs.add(spec);
        }
        return specs;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }
}

