/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.IdentifiedObject;
import org.obo.filters.SearchCriterion;
import org.obo.query.StringQuery;
import org.obo.query.impl.ScoredCriterionHit;
import org.obo.query.impl.ScoredPathHit;
import org.obo.query.impl.ScoredStringHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoredPathQuery
implements StringQuery<FieldPath, ScoredPathHit> {
    protected static final Logger logger = Logger.getLogger(ScoredPathQuery.class);
    protected List<FieldPathSpec> specs = new LinkedList<FieldPathSpec>();
    protected Map<SearchCriterion<IdentifiedObject, String>, Double> weightMap = new HashMap<SearchCriterion<IdentifiedObject, String>, Double>();
    protected boolean ignoreCase = true;
    protected Collection<String> searchWords;
    protected String searchString;
    protected Comparator<SearchCriterion<IdentifiedObject, String>> weightComparator = new Comparator<SearchCriterion<IdentifiedObject, String>>(){

        @Override
        public int compare(SearchCriterion<IdentifiedObject, String> o1, SearchCriterion<IdentifiedObject, String> o2) {
            return (int)(ScoredPathQuery.this.getWeight(o2) - ScoredPathQuery.this.getWeight(o1));
        }
    };
    protected FieldPath path;

    public void clear() {
        this.specs.clear();
        this.weightMap.clear();
    }

    public void addPathSpec(FieldPathSpec spec) {
        this.addPathSpec(spec, 1.0);
    }

    public void addPathSpec(FieldPathSpec spec, Double weight) {
        this.specs.add(spec);
        this.weightMap.put(spec.getLastCriterion(), weight);
    }

    public double getWeight(SearchCriterion<IdentifiedObject, String> criterion) {
        Double d = this.weightMap.get(criterion);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public FieldPath convertToInputType(ScoredPathHit original) {
        return (FieldPath)original.getHit();
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void setSearchString(String searchString) {
        this.searchWords = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(searchString);
        while (tokenizer.hasMoreTokens()) {
            this.searchWords.add(tokenizer.nextToken());
        }
        this.searchString = searchString;
    }

    public String getString(String s) {
        if (this.ignoreCase) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public ScoredPathHit matches(FieldPath a) {
        ScoredPathHit scoredQueryHit = null;
        LinkedList hits = new LinkedList();
        LinkedList scratch = new LinkedList();
        double score = 0.0;
        for (FieldPathSpec spec : this.specs) {
            SearchCriterion criterion = spec.getLastCriterion();
            scratch.clear();
            criterion.getValues(scratch, a.getLastValue());
            ScoredCriterionHit scoredCriterionHit = null;
            boolean failed = false;
            for (String s : scratch) {
                s = this.getString(s);
                for (String searchWord : this.searchWords) {
                    int pos = s.indexOf(this.getString(searchWord));
                    double wordscore = ScoredPathQuery.getMatchPosScore(pos, s);
                    if (wordscore > 0.0) {
                        ScoredStringHit scoredStringHit = new ScoredStringHit(searchWord, s, wordscore, pos);
                        if (scoredCriterionHit == null) {
                            scoredCriterionHit = new ScoredCriterionHit(criterion, this.weightMap.get(criterion), s);
                        }
                        scoredCriterionHit.addStringHit(scoredStringHit);
                        continue;
                    }
                    failed = true;
                    break;
                }
                if (!failed) continue;
                scoredCriterionHit = null;
                break;
            }
            if (scoredCriterionHit == null) continue;
            if (scoredQueryHit == null) {
                scoredQueryHit = new ScoredPathHit(this.path);
            }
            scoredQueryHit.addCriterionHit(scoredCriterionHit);
        }
        return scoredQueryHit;
    }

    protected static int getMatchPosScore(int index, String str) {
        if (index >= 0) {
            if (index == 0) {
                return 10;
            }
            if (Character.isWhitespace(str.charAt(index - 1))) {
                return 5;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public Comparator<ScoredPathHit> getComparator() {
        return ScoredPathHit.COMPARATOR;
    }

    @Override
    public Collection<ScoredPathHit> createResultHolder() {
        return new ArrayList<ScoredPathHit>();
    }

    @Override
    public Class<FieldPath> getInputType() {
        return FieldPath.class;
    }

    @Override
    public ScoredPathHit convertToOutputType(FieldPath original) {
        return null;
    }

    public Comparator<SearchCriterion<IdentifiedObject, String>> getWeightComparator() {
        return this.weightComparator;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return this.specs;
    }

    @Override
    public void setFieldPath(FieldPath path) {
        this.path = path;
    }
}

