/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.filters.SearchCriterion;
import org.obo.query.impl.BasicSearchHit;
import org.obo.query.impl.ScoredCriterionHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoredQueryHit
extends BasicSearchHit<IdentifiedObject> {
    protected static final Logger logger = Logger.getLogger(ScoredQueryHit.class);
    protected IdentifiedObject object;
    protected Collection<ScoredCriterionHit> criterionHits;
    public static final Comparator<ScoredQueryHit> COMPARATOR = new Comparator<ScoredQueryHit>(){

        @Override
        public int compare(ScoredQueryHit o1, ScoredQueryHit o2) {
            int val = (int)(o2.getScore() - o1.getScore());
            if (val == 0) {
                return ((IdentifiedObject)o1.getHit()).getName().compareToIgnoreCase(((IdentifiedObject)o2.getHit()).getName());
            }
            return val;
        }
    };

    public ScoredQueryHit(IdentifiedObject object) {
        super(object);
    }

    public Collection<ScoredCriterionHit> getHitsForCriterion(SearchCriterion crit) {
        return this.getHitsForCriterion(crit.getID());
    }

    public Collection<ScoredCriterionHit> getHitsForCriterion(String critID) {
        LinkedList<ScoredCriterionHit> out = new LinkedList<ScoredCriterionHit>();
        for (ScoredCriterionHit hit : this.criterionHits) {
            if (!hit.getCriterion().getID().equals(critID)) continue;
            out.add(hit);
        }
        return out;
    }

    public void addCriterionHit(ScoredCriterionHit hit) {
        if (this.criterionHits == null) {
            this.criterionHits = new LinkedList<ScoredCriterionHit>();
        }
        this.criterionHits.add(hit);
    }

    public double getScore() {
        double score = 0.0;
        for (ScoredCriterionHit hit : this.criterionHits) {
            score += hit.getScore();
        }
        return score;
    }

    public Collection<ScoredCriterionHit> getCriterionHits() {
        return this.criterionHits;
    }
}

