/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.CompletenessExplanation;
import org.obo.reasoner.impl.CompletenessMatch;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionRule
extends AbstractReasonerRule {
    protected static final Logger logger = Logger.getLogger(IntersectionRule.class);
    protected MultiMap<LinkedObject, Link> intersectionMap;
    protected MultiMap<LinkedObject, LinkedObject> hintMap;

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.buildIntersectionMap(reasoner);
    }

    protected void buildIntersectionMap(ReasonedLinkDatabase reasoner) {
        this.intersectionMap = new MultiHashMap();
        this.hintMap = new MultiHashMap();
        for (IdentifiedObject io : reasoner.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : lo.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                this.intersectionMap.add((Object)lo, (Object)link);
                this.hintMap.add((Object)link.getParent(), (Object)lo);
            }
        }
    }

    @Override
    protected Collection<Explanation> doGetImplications(ReasonedLinkDatabase reasoner, Link newLink) {
        Collection candidates = (Collection)this.hintMap.get((Object)newLink.getParent());
        ArrayList<Explanation> out = new ArrayList<Explanation>(candidates.size());
        LinkedList<CompletenessMatch> matchList = new LinkedList<CompletenessMatch>();
        LinkedObject newLinkChild = newLink.getChild();
        for (LinkedObject lo : candidates) {
            if (lo.equals(newLinkChild)) continue;
            boolean failed = false;
            matchList.clear();
            Collection intersectionLinks = (Collection)this.intersectionMap.get((Object)lo);
            for (Link link : intersectionLinks) {
                Link matchLink = reasoner.hasRelationship(newLinkChild, link.getType(), link.getParent());
                if (matchLink == null) {
                    failed = true;
                    break;
                }
                matchList.add(new CompletenessMatch(matchLink, link));
            }
            if (failed) continue;
            Link genLink = this.createLink(newLinkChild, OBOProperty.IS_A, lo);
            CompletenessExplanation exp = new CompletenessExplanation();
            exp.setExplainedLink(genLink);
            for (CompletenessMatch match : matchList) {
                exp.addMatch(match);
            }
            out.add(exp);
        }
        return out;
    }
}

