/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.ReasonerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonerPassthroughLinkDatabase
extends AbstractLinkDatabase
implements ReasonedLinkDatabase {
    protected static final Logger logger = Logger.getLogger(ReasonerPassthroughLinkDatabase.class);
    protected ReasonedLinkDatabase reasoner;
    protected LinkDatabase linkDatabase;
    protected Collection<ReasonerListener> listeners = new LinkedList<ReasonerListener>();

    public ReasonerPassthroughLinkDatabase(LinkDatabase linkDatabase) {
        this.setDelegateLinkDatabase(linkDatabase);
    }

    public boolean isReasonerEnabled() {
        return this.reasoner != null;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        for (ReasonerListener listener : this.listeners) {
            if (this.reasoner != null) {
                this.reasoner.removeReasonerListener(listener);
            }
            reasoner.addReasonerListener(listener);
        }
        this.reasoner = reasoner;
    }

    @Override
    public boolean isRunning() {
        if (this.reasoner != null) {
            return this.reasoner.isRunning();
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (this.reasoner != null) {
            return this.reasoner.isCancelled();
        }
        return false;
    }

    public void setDelegateLinkDatabase(LinkDatabase linkDatabase) {
        if (linkDatabase == null) {
            throw new IllegalArgumentException("null linkDatabases not allowed");
        }
        this.linkDatabase = linkDatabase;
    }

    @Override
    public void addLink(Link link) {
        if (this.reasoner != null) {
            this.reasoner.addLink(link);
        }
    }

    @Override
    public void addReasonerListener(ReasonerListener listener) {
        this.listeners.add(listener);
        if (this.reasoner != null) {
            this.reasoner.addReasonerListener(listener);
        }
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        if (this.reasoner != null) {
            return this.reasoner.getChildren(lo);
        }
        return this.linkDatabase.getChildren(lo);
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable link) {
        if (this.reasoner != null) {
            return this.reasoner.getExplanations(link);
        }
        return Collections.emptyList();
    }

    @Override
    public LinkDatabase getLinkDatabase() {
        if (this.reasoner != null) {
            return this.reasoner.getLinkDatabase();
        }
        return this.linkDatabase;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        if (this.reasoner != null) {
            return this.reasoner.getObject(id);
        }
        return this.linkDatabase.getObject(id);
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.reasoner != null) {
            return this.reasoner.getObjects();
        }
        return this.linkDatabase.getObjects();
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        if (this.reasoner != null) {
            return this.reasoner.getParents(lo);
        }
        return this.linkDatabase.getParents(lo);
    }

    @Override
    public Collection<LinkedObject> getParentsOfType(LinkedObject a, OBOProperty prop) {
        if (this.reasoner != null) {
            return this.reasoner.getParentsOfType(a, prop);
        }
        return Collections.emptyList();
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty prop, LinkedObject b) {
        if (this.reasoner != null) {
            return this.reasoner.hasRelationship(a, prop, b);
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(Instance a, OBOClass b) {
        if (this.reasoner != null) {
            return this.reasoner.isInstanceOf(a, b);
        }
        return false;
    }

    @Override
    public boolean isRedundant(Link link) {
        if (this.reasoner != null) {
            return this.reasoner.isRedundant(link);
        }
        return false;
    }

    @Override
    public boolean isSubclassOf(OBOClass a, OBOClass b) {
        if (this.reasoner != null) {
            return this.reasoner.isSubclassOf(a, b);
        }
        return false;
    }

    @Override
    public boolean isSubPropertyOf(OBOProperty a, OBOProperty b) {
        if (this.reasoner != null) {
            return this.reasoner.isSubPropertyOf(a, b);
        }
        return false;
    }

    @Override
    public long recache() {
        if (this.reasoner != null) {
            return this.reasoner.recache();
        }
        return 0L;
    }

    @Override
    public void removeLink(Link link) {
        if (this.reasoner != null) {
            this.reasoner.removeLink(link);
        }
    }

    @Override
    public void removeReasonerListener(ReasonerListener listener) {
        this.listeners.remove(listener);
        if (this.reasoner != null) {
            this.reasoner.removeReasonerListener(listener);
        }
    }

    @Override
    public void setLinkDatabase(LinkDatabase linkDatabase) {
        if (this.reasoner != null) {
            this.reasoner.setLinkDatabase(linkDatabase);
        }
    }

    public String getProgressString() {
        if (this.reasoner != null) {
            return this.reasoner.getProgressString();
        }
        return null;
    }

    public Number getProgressValue() {
        if (this.reasoner != null) {
            return this.reasoner.getProgressValue();
        }
        return null;
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        if (this.reasoner != null) {
            return this.reasoner.hasChildren(lo);
        }
        return this.linkDatabase.hasChildren(lo);
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        if (this.reasoner != null) {
            return this.reasoner.hasParents(lo);
        }
        return this.linkDatabase.hasParents(lo);
    }
}

