/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.rbr.AbstractExplanation;
import org.obo.reasoner.rbr.IntersectionMatch;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionExplanation
extends AbstractExplanation {
    protected static final Logger logger = Logger.getLogger(IntersectionExplanation.class);
    private static final long serialVersionUID = 6982440827960096291L;
    protected Collection<IntersectionMatch> matches = new ArrayList<IntersectionMatch>(2);

    public Collection<IntersectionMatch> getMatches() {
        return this.matches;
    }

    public void addMatch(IntersectionMatch match) {
        if (!this.matches.contains(match)) {
            this.matches.add(match);
        }
    }

    protected void removeMatch(IntersectionMatch match) {
        this.matches.remove(match);
    }

    @Override
    public boolean removeEvidence(Link link) {
        for (IntersectionMatch match : this.matches) {
            if (!match.getMatchLink().equals(link) && !match.getCompletenessLink().equals(link)) continue;
            this.removeMatch(match);
            break;
        }
        boolean broken = !this.isSupported();
        return broken;
    }

    @Override
    public Collection<Link> getEvidence() {
        ArrayList<Link> out = new ArrayList<Link>(this.matches.size() * 2);
        for (IntersectionMatch m : this.matches) {
            out.add(m.getCompletenessLink());
            out.add(m.getMatchLink());
        }
        return out;
    }

    protected boolean isSupported() {
        LinkedObject matchParent = this.getExplainedLink().getParent();
        for (Link link : matchParent.getParents()) {
            if (!TermUtil.isIntersection(link)) continue;
            boolean found = false;
            for (IntersectionMatch match : this.matches) {
                if (!match.getCompletenessLink().equals(link)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExplanationType getExplanationType() {
        return ExplanationType.INTERSECTION;
    }

    @Override
    public String toString() {
        return "XP: matches=" + this.matches;
    }
}

