/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashSetMap;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.ValueLink;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.impl.AbstractReasoner;
import org.obo.reasoner.impl.GivenExplanation;
import org.obo.reasoner.rbr.AbstractExplanation;
import org.obo.reasoner.rbr.AbstractRule;
import org.obo.reasoner.rbr.IntersectionRule;
import org.obo.reasoner.rbr.LinkCompositionRule;
import org.obo.reasoner.rbr.PropertyIntersectionRule;
import org.obo.reasoner.rbr.RelationCompositionTable;
import org.obo.reasoner.rbr.Rule;
import org.obo.reasoner.rbr.SubPropertyRule;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedReasoner
extends AbstractReasoner {
    protected static final Logger logger = Logger.getLogger(RuleBasedReasoner.class);
    protected List<Rule> rules = new ArrayList<Rule>();
    protected int lastVal;
    protected HashMap<Link, Link> linkMap;
    protected HashMap<OBOProperty, Link> propertyLinkMap;
    protected RelationCompositionTable rct;
    protected Map<Link, Collection<Explanation>> explanationMap;

    public RuleBasedReasoner() {
        this.addDefaultRules();
    }

    protected void addDefaultRules() {
        this.addRule(new SubPropertyRule());
        this.addRule(new LinkCompositionRule());
        this.addRule(new PropertyIntersectionRule());
        this.addRule(new IntersectionRule());
    }

    public boolean hasDelayedIncrementalMode() {
        return true;
    }

    public RelationCompositionTable getRelationCompositionTable() {
        return this.rct;
    }

    @Override
    protected void initReasoner() {
        this.running = true;
        this.fireStart();
        this.impliedLinkDatabase = this.createImpliedLinkDatabase(this.getLinkDatabase());
        this.rct = new RelationCompositionTable(this.getLinkDatabase());
        logger.info((Object)("RCT:\n" + this.rct.toTable()));
        this.explanationMap = new HashMap<Link, Collection<Explanation>>();
        this.explanationDeps = new MultiHashSetMap();
        Iterator<Link> it = TermUtil.getAllLinks(this.linkDatabase);
        while (it.hasNext()) {
            Link link = it.next();
            if (link instanceof ValueLink) continue;
            GivenExplanation e = new GivenExplanation(link);
            this.addExplanation(e);
        }
    }

    public void findNewImplications() {
        this.doReasoning();
    }

    @Override
    protected void doReasoning() {
        long initTime = System.nanoTime();
        for (Rule rule : this.rules) {
            rule.init(this);
        }
        this.setProgressString("Initializing reasoner...");
        this.setProgressString("Reasoning...");
        boolean isExhausted = false;
        int sweep = 0;
        int newLinks = 0;
        while (!isExhausted) {
            logger.info((Object)("sweep: " + ++sweep));
            isExhausted = true;
            for (Rule rule : this.rules) {
                logger.info((Object)("  rule: " + rule));
                Collection<Explanation> expls = rule.getNewInferences(this);
                if (expls == null) continue;
                for (Explanation expl : expls) {
                    Link link = (Link)expl.getExplainedObject();
                    if (link.getChild().equals(link.getParent())) continue;
                    Link existingLink = this.hasRelationship(link.getChild(), link.getType(), link.getParent());
                    if (!this.addExplanation(expl)) continue;
                    ++newLinks;
                    isExhausted = false;
                }
                logger.info((Object)("  new links: " + newLinks));
            }
        }
        logger.info((Object)("finished on sweep: " + sweep));
        logger.info((Object)("new links: " + newLinks));
        for (Rule rule : this.rules) {
            rule.end(this);
        }
        long totalTime = System.nanoTime() - initTime;
        logger.info((Object)("   Total reasoner time = " + (double)totalTime / 1000000.0 + " ms"));
        for (Rule rule : this.rules) {
            if (!(rule instanceof AbstractRule)) continue;
            logger.info((Object)("   time in rule (" + rule + ") = " + (double)((AbstractRule)rule).ruleTime / 1000000.0 + " ms"));
        }
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        rule.install(this);
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule);
        rule.uninstall(this);
    }

    protected boolean addExplanation(Explanation explanation) {
        Link link = (Link)explanation.getExplainedObject();
        return this.addLinkWithExplanation(link, explanation);
    }

    private boolean addLinkWithExplanation(Link link, Explanation explanation) {
        this.internalAddLink(link);
        long time = System.nanoTime();
        Collection<Explanation> existingExpls = this.getExplanations(link);
        if (existingExpls.size() > 1) {
            return false;
        }
        if (existingExpls.size() == 1 && !existingExpls.iterator().next().getExplanationType().equals((Object)ExplanationType.GIVEN)) {
            return false;
        }
        if (!this.explanationMap.containsKey(link)) {
            this.explanationMap.put(link, new ArrayList());
        }
        this.explanationMap.get(link).add(explanation);
        for (Link evidence : explanation.getEvidence()) {
            this.explanationDeps.add((Object)evidence, (Object)explanation);
        }
        this.expTime += System.nanoTime() - time;
        return true;
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable link) {
        if (this.explanationMap.containsKey(link)) {
            return this.explanationMap.get(link);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void doAddLink(Link link) {
        this.addExplanation(new GivenExplanation(link));
        this.doReasoning();
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        return this.impliedLinkDatabase.getChildren(lo);
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        return this.impliedLinkDatabase.getParents(lo);
    }

    @Override
    protected void doRemoveLink(Link link) {
        this.cascadingRemoveLink(link);
    }

    protected void cascadingRemoveLink(Link link) {
        logger.info((Object)("removing link:" + link));
        this.impliedLinkDatabase.removeParent(link);
        this.explanationMap.remove(link);
        Collection deps = (Collection)this.explanationDeps.get((Object)link);
        if (deps == null) {
            return;
        }
        HashSet<Link> togo = new HashSet<Link>();
        for (Explanation exp : deps) {
            Link depLink = (Link)exp.getExplainedObject();
            logger.debug((Object)("link : " + link + " // has DEP: " + depLink + " // via EXPL: " + exp));
            togo.add(depLink);
        }
        this.explanationDeps.remove((Object)link);
        for (Link depLink : togo) {
            this.cascadingRemoveLink(depLink);
        }
    }

    @Override
    public Set<LinkedObject> getParentsOfType(LinkedObject a, OBOProperty prop) {
        LinkedHashSet<LinkedObject> out = new LinkedHashSet<LinkedObject>();
        for (Link link : this.getParents(a)) {
            if (!link.getType().equals(prop)) continue;
            out.add(link.getParent());
        }
        return out;
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty prop, LinkedObject b) {
        for (Link link : this.getParents(a)) {
            if (!link.getParent().equals(b) || !link.getType().equals(prop)) continue;
            return link;
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(Instance a, OBOClass b) {
        return false;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public boolean isSubPropertyOf(OBOProperty a, OBOProperty b) {
        return this.hasRelationship(a, OBOProperty.IS_A, b) != null;
    }

    @Override
    public boolean isSubclassOf(OBOClass a, OBOClass b) {
        return this.hasRelationship(a, OBOProperty.IS_A, b) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReasonerLink
    implements Link {
        protected LinkedObject child;
        protected LinkedObject parent;
        protected OBOProperty type;
        protected boolean lookedAt;
        protected HashSet<AbstractExplanation> explanations;
        protected String id;
        protected int hash;

        public ReasonerLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
            this.child = child;
            this.type = type;
            this.parent = parent;
            this.id = child.getID() + '-' + type.getID() + "->" + parent.getID();
            this.hash = child.hashCode() + type.hashCode() + parent.hashCode();
        }

        public Collection<AbstractExplanation> getExplanations() {
            if (this.explanations == null) {
                return Collections.emptyList();
            }
            return this.explanations;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void addExplanation(AbstractExplanation exp) {
            exp.setExplainedLink(this);
            if (this.explanations == null) {
                this.explanations = new HashSet(5);
            }
            this.explanations.add(exp);
        }

        public void removeExplanation(AbstractExplanation exp) {
            if (this.explanations != null) {
                this.explanations.remove(exp);
            }
        }

        @Override
        public boolean isImplied() {
            return true;
        }

        @Override
        public String getID() {
            return this.id;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.child + " -> " + this.type + " -> " + this.parent;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Link) {
                return TermUtil.equals(this, (Link)o);
            }
            return false;
        }

        @Override
        public void setNestedValue(NestedValue nv) {
        }

        @Override
        public NestedValue getNestedValue() {
            return null;
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public void setNamespace(Namespace namespace) {
        }

        @Override
        public Namespace getNamespace() {
            return null;
        }

        @Override
        public LinkedObject getChild() {
            return this.child;
        }

        @Override
        public void setChild(LinkedObject child) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinkedObject getParent() {
            return this.parent;
        }

        @Override
        public void setParent(LinkedObject parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OBOProperty getType() {
            return this.type;
        }

        @Override
        public void setType(OBOProperty type) {
            throw new UnsupportedOperationException();
        }

        public boolean isLookedAt() {
            return this.lookedAt;
        }

        public void setLookedAt(boolean lookedAt) {
            this.lookedAt = lookedAt;
        }
    }
}

