/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.GOStyleAnnotationFileAdapter;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.test.AbstractAnnotationTest;
import org.obo.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOAnnotationFileTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(GOAnnotationFileTest.class);
    String outPath;

    public GOAnnotationFileTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"gene_association.fb"};
        return Arrays.asList(files);
    }

    @Override
    public void setUp() throws Exception {
        logger.info((Object)("Setting up: " + (Object)((Object)this)));
        ForwardChainingReasoner.checkRecache = false;
        GOStyleAnnotationFileAdapter adapter = new GOStyleAnnotationFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String f : this.getFilesToLoad()) {
            config.getReadPaths().add(this.getResourcePath() + "/" + f);
            logger.info((Object)f);
        }
        config.setAllowDangling(true);
        config.setBasicSave(false);
        config.setFailFast(false);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        this.linkDatabase = new DefaultLinkDatabase(this.session);
    }

    public void loadAnnotations(String f) throws DataAdapterException {
        GOStyleAnnotationFileAdapter adapter = new GOStyleAnnotationFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(f);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    public void testRoundTrip() throws DataAdapterException, IOException {
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        File outFile = File.createTempFile("foo", "bar");
        this.outPath = outFile.getAbsolutePath();
        config.setWritePath(this.outPath);
        GOStyleAnnotationFileAdapter adapter = new GOStyleAnnotationFileAdapter();
        adapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)config, this.session);
        this.loadAnnotations(this.outPath);
        this.testAnnot();
    }

    public void testAnnot() {
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(this.session);
        for (Annotation annot : annots) {
            logger.info((Object)annot);
        }
        logger.info((Object)("N annots:" + annots.size()));
        this.testForName("FB:FBgn0061475", "18SrRNA");
        this.testForAnnotation("FB:FBgn0024177", "GO:0005921");
        this.testForAnnotationAssignedBy("FB:FBgn0061475", "GO:0005843", "FlyBase");
        this.testForAnnotationPublication("FB:FBgn0061475", "GO:0005843", "FB:FBrf0121292");
        this.testForAnnotationWithEvidenceCode("FB:FBgn0061475", "GO:0005843", "ISS");
        this.testForNamespace("FB:FBgn0061475", "FB");
        this.testForLink("FB:FBgn0061475", "has_taxon", "taxon:7227");
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        GOAnnotationFileTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new GOAnnotationFileTest("testAnnot"));
        suite.addTest((Test)new GOAnnotationFileTest("testRoundTrip"));
    }
}

