/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.DefaultReasonerFactory;
import org.obo.test.AbstractOBOTest;
import org.obo.util.IDMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMapperTestWithReasoner
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(IDMapperTestWithReasoner.class);
    IDMapper mapper;

    public IDMapperTestWithReasoner(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"regulation_of_transcription_xp.obo"};
        return Arrays.asList(files);
    }

    private void showObjs(Collection<OBOObject> objs) {
        for (OBOObject obj : objs) {
            logger.info((Object)(obj.getID() + " " + obj.getName()));
        }
    }

    public void testMapIDs() throws IOException {
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        DefaultReasonerFactory rf = new DefaultReasonerFactory();
        ReasonedLinkDatabase reasoner = rf.createReasoner();
        this.mapper.setReasoner(reasoner);
        reasoner.recache();
        Collection<OBOObject> mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0006355", false);
        this.showObjs(mappedObjs);
        IDMapperTestWithReasoner.assertTrue((mappedObjs.size() == 2 ? 1 : 0) != 0);
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        this.mapper.setReasoner(reasoner);
        reasoner.recache();
        this.mapper.addPropertyToTraverse("regulates");
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0006357", false);
        this.showObjs(mappedObjs);
        IDMapperTestWithReasoner.assertTrue((mappedObjs.size() == 1 ? 1 : 0) != 0);
        IDMapperTestWithReasoner.assertTrue((boolean)mappedObjs.iterator().next().equals(new OBOClassImpl("GO:0006350")));
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0021882", false);
        this.showObjs(mappedObjs);
        IDMapperTestWithReasoner.assertTrue((mappedObjs.size() == 1 ? 1 : 0) != 0);
        IDMapperTestWithReasoner.assertTrue((boolean)mappedObjs.iterator().next().equals(new OBOClassImpl("GO:0006350")));
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_plant");
        this.mapper.addCategory("gosubset_prok");
        this.mapper.setReasoner(reasoner);
        reasoner.recache();
        this.mapper.addPropertyToTraverse("part_of");
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0021882", false);
        this.showObjs(mappedObjs);
        IDMapperTestWithReasoner.assertTrue((mappedObjs.size() == 1 ? 1 : 0) != 0);
        IDMapperTestWithReasoner.assertTrue((boolean)mappedObjs.iterator().next().equals(new OBOClassImpl("GO:0030154")));
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0021882", false);
        this.showObjs(mappedObjs);
    }
}

