/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.io.AuditedPrintStream;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.reasoner.impl.ForwardChainingReasonerFactory;
import org.obo.reasoner.impl.ReasonerOperationModel;
import org.obo.reasoner.impl.TransitivityExplanation;
import org.obo.test.AbstractReasonerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonerUndoRedoTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(ReasonerUndoRedoTest.class);

    public ReasonerUndoRedoTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"gene_ontology_edit.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testLinks() throws Exception {
        ReasonerOperationModel reasonerOpModel = new ReasonerOperationModel(this.reasonedDB);
        reasonerOpModel.setSession(this.session);
        this.session.getOperationModel().addLockstepModel(reasonerOpModel);
        ArrayList<Link> allLinks = new ArrayList<Link>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            for (Link link : ((LinkedObject)io).getParents()) {
                allLinks.add(link);
            }
        }
        for (Link link : allLinks) {
            DeleteLinkHistoryItem item = new DeleteLinkHistoryItem(link);
            this.session.getOperationModel().apply(item);
            this.session.getOperationModel().reverse(item);
            this.session.getOperationModel().apply(item);
            this.session.getOperationModel().reverse(item);
        }
    }

    protected void checkForDeadExps() {
        if (this.reasonedDB instanceof ForwardChainingReasoner) {
            ForwardChainingReasoner reasoner = (ForwardChainingReasoner)this.reasonedDB;
            this.checkForDeadExps(reasoner.getExplanationMap().values());
            this.checkForDeadExps(reasoner.getExplanationDepsMap().values());
        }
    }

    protected void checkForDeadExps(Collection<Collection<Explanation>> expsC) {
        for (Collection<Explanation> exps : expsC) {
            for (Explanation exp : exps) {
                if (!(exp instanceof TransitivityExplanation)) continue;
                TransitivityExplanation t = (TransitivityExplanation)exp;
                ReasonerUndoRedoTest.assertTrue((t.getDirectLink() != null ? 1 : 0) != 0);
                ReasonerUndoRedoTest.assertTrue((t.getExtensionLink() != null ? 1 : 0) != 0);
            }
        }
    }

    public static Test suite() {
        ReasonerUndoRedoTest.setReasonerFactory(new ForwardChainingReasonerFactory());
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        ReasonerUndoRedoTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new ReasonerUndoRedoTest("testLinks"));
    }
}

