/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.filters.LinkFilterFactory;
import org.obo.filters.ObjectFilterFactory;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.test.AbstractReasonerTest;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveRedundantLinksTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(RemoveRedundantLinksTest.class);
    LinkFilterFactory lff = new LinkFilterFactory();
    ObjectFilterFactory off = new ObjectFilterFactory();

    public RemoveRedundantLinksTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"regulation_of_anti_apoptosis_xp.obo"};
        return Arrays.asList(files);
    }

    public void testRemoveRedundant() throws Exception {
        boolean found;
        Collection<Link> rls = ReasonerUtil.getAllRedundantLinks(this.reasonedDB, this.session.getLinkDatabase());
        logger.info((Object)("num redundant links: " + rls.size()));
        boolean aaCheck = true;
        boolean rmCheck = false;
        boolean rmCheck2 = false;
        for (Link rl : rls) {
            logger.info((Object)("redundant: " + rl + " " + TermUtil.isIntersection(rl)));
            if (rl.getChild().getName().equals("anti-apoptosis")) {
                aaCheck = false;
            }
            if (rl.getChild().getName().equals("regulation of gene expression") && rl.getParent().getName().equals("regulation of cellular process")) {
                rmCheck = true;
            }
            if (!rl.getChild().getName().equals("negative regulation of programmed cell death") || !rl.getParent().getName().equals("negative regulation of cellular process")) continue;
            rmCheck2 = true;
        }
        RemoveRedundantLinksTest.assertTrue((rls.size() > 15 ? 1 : 0) != 0);
        RemoveRedundantLinksTest.assertTrue((boolean)aaCheck);
        HashSet<Link> ilinks = new HashSet<Link>();
        Iterator<Link> it = TermUtil.getAllLinks(this.session.getLinkDatabase());
        while (it.hasNext()) {
            Link link = it.next();
            if (!TermUtil.isIntersection(link)) continue;
            ilinks.add(link);
        }
        RemoveRedundantLinksTest.assertTrue((ilinks.size() > 30 ? 1 : 0) != 0);
        TermMacroHistoryItem item = new TermMacroHistoryItem("Delete " + rls.size() + " redundant links");
        for (Link link : rls) {
            item.addItem(new DeleteLinkHistoryItem(link));
        }
        this.session.getOperationModel().apply(item);
        it = TermUtil.getAllLinks(this.session.getLinkDatabase());
        while (it.hasNext()) {
            Link link = it.next();
            if (link.isImplied() || TermUtil.isIntersection(link)) continue;
            logger.info((Object)("remaining asserted non-xp: " + link + " " + TermUtil.isIntersection(link)));
        }
        logger.info((Object)("checking that no intersection links disappeared; num=" + ilinks.size()));
        boolean pass = true;
        for (Link ilink : ilinks) {
            found = false;
            for (Link elink : this.session.getLinkDatabase().getParents(ilink.getChild())) {
                if (!elink.equals(ilink)) continue;
                if (TermUtil.isIntersection(elink)) {
                    logger.info((Object)("found: " + ilink));
                    found = true;
                    break;
                }
                logger.info((Object)("replaced by non-intersection?: " + elink));
            }
            if (!found) {
                logger.error((Object)("cannot find: " + ilink));
                pass = false;
            }
            RemoveRedundantLinksTest.assertTrue((boolean)pass);
        }
        logger.info((Object)("checking that all redundant links have disappeared; num=" + rls.size()));
        pass = true;
        for (Link rl : rls) {
            found = false;
            for (Link elink : this.session.getLinkDatabase().getParents(rl.getChild())) {
                if (!elink.equals(rl)) continue;
                found = true;
                break;
            }
            if (found) {
                logger.error((Object)("failed to remove: " + rl));
                pass = false;
            } else {
                logger.info((Object)("successfully removed: " + rl));
            }
            RemoveRedundantLinksTest.assertTrue((boolean)pass);
        }
        LinkedObject aa = (LinkedObject)this.session.getObject("GO:0006916");
        RemoveRedundantLinksTest.assertTrue((aa.getParents().size() == 1 ? 1 : 0) != 0);
    }
}

