/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.OBOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterUtil {
    protected static final Logger logger = Logger.getLogger(AdapterUtil.class);

    public static OBOSession parseFile(String path) throws DataAdapterException {
        return AdapterUtil.parseFiles(Collections.singleton(path));
    }

    public static OBOSession parseFiles(Collection<String> paths) throws DataAdapterException {
        return AdapterUtil.parseFiles(paths, true);
    }

    public static OBOSession parseFiles(Collection<String> paths, boolean allowDangling) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String path : paths) {
            config.getReadPaths().add(path);
        }
        config.setAllowDangling(allowDangling);
        config.setBasicSave(false);
        config.setFailFast(false);
        OBOSession session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        return session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdapterFormat {
        OBO,
        OWL;

    }
}

