/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.annotation.datamodel.Annotation;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    protected static final Logger logger = Logger.getLogger(AnnotationUtil.class);

    public static Collection<Annotation> getAnnotationsForSubject(OBOSession session, IdentifiedObject su) {
        LinkedList<Annotation> annots = new LinkedList<Annotation>();
        for (IdentifiedObject io : session.getObjects()) {
            Annotation annot;
            if (!(io instanceof Annotation) || (annot = (Annotation)io).getSubject() == null || annot.getObject() == null || !su.equals(annot.getSubject())) continue;
            annots.add(annot);
        }
        return annots;
    }

    public static Collection<Annotation> getAnnotationsForObject(OBOSession session, IdentifiedObject ob) {
        LinkedList<Annotation> annots = new LinkedList<Annotation>();
        for (IdentifiedObject io : session.getObjects()) {
            Annotation annot;
            if (!(io instanceof Annotation) || (annot = (Annotation)io).getSubject() == null || annot.getObject() == null || !ob.equals(annot.getObject())) continue;
            annots.add(annot);
        }
        return annots;
    }

    public static Set<OBOObject> getSubjectsAnnotatedWithObject(OBOSession session, IdentifiedObject ob) {
        Collection<Annotation> annots = AnnotationUtil.getAnnotationsForObject(session, ob);
        HashSet<OBOObject> subjs = new HashSet<OBOObject>();
        for (Annotation annot : annots) {
            subjs.add((OBOObject)annot.getSubject());
        }
        return subjs;
    }

    public static Collection<Annotation> getAnnotations(OBOSession session) {
        LinkedList<Annotation> annots = new LinkedList<Annotation>();
        for (IdentifiedObject io : session.getObjects()) {
            Annotation annot;
            if (!(io instanceof Annotation) || (annot = (Annotation)io).getSubject() == null || annot.getObject() == null) continue;
            annots.add(annot);
        }
        return annots;
    }

    public static Collection<OBOObject> getAnnotationSubjects(OBOSession session) {
        HashSet<OBOObject> subjs = new HashSet<OBOObject>();
        for (IdentifiedObject io : session.getObjects()) {
            Annotation annot;
            if (!(io instanceof Annotation) || (annot = (Annotation)io).getSubject() == null || annot.getObject() == null) continue;
            OBOObject subj = (OBOObject)annot.getSubject();
            subjs.add(subj);
        }
        return subjs;
    }

    public static Collection<OBOObject> getAnnotationObjects(OBOSession session) {
        HashSet<OBOObject> objs = new HashSet<OBOObject>();
        for (IdentifiedObject io : session.getObjects()) {
            if (!(io instanceof Annotation)) continue;
            OBOObject obj = (OBOObject)((Annotation)io).getObject();
            objs.add(obj);
        }
        return objs;
    }
}

