/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.TermSubset;
import org.obo.filters.Filter;
import org.obo.filters.ObjectFilterImpl;
import org.obo.filters.SubsetSearchCriterion;
import org.obo.identifier.IDResolution;
import org.obo.identifier.IDWarning;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.util.FilterUtil;
import org.obo.util.IDUtil;
import org.obo.util.SessionWrapper;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMapper
extends SessionWrapper {
    protected static final Logger logger = Logger.getLogger(IDMapper.class);
    private ReasonedLinkDatabase reasoner;
    private Collection<OBOProperty> propertiesToTraverse;
    private IDFileMetadata fileMetadata = new IDFileMetadata();
    private Collection<TermSubset> categories = new HashSet<TermSubset>();
    private Filter filter;
    private MapperInputParams inputParams;
    private Map<MapperInputParams, Map<String, Collection<OBOObject>>> cacheMap = new HashMap<MapperInputParams, Map<String, Collection<OBOObject>>>();
    private Map<String, Integer> entityCountByOboIDMap;
    private MultiMap<String, IdentifiedObject> secondaryIDMap = null;
    private Collection<IDWarning> warnings = new HashSet<IDWarning>();
    private boolean autoReplaceConsiderTags = false;

    public MultiMap<String, IdentifiedObject> getSecondaryIDMap() {
        if (this.secondaryIDMap == null) {
            this.secondaryIDMap = IDUtil.getSecondaryIDMap(this.getSession());
        }
        return this.secondaryIDMap;
    }

    public Collection<IDWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Collection<IDWarning> warnings) {
        this.warnings = warnings;
    }

    public void addWarning(IDWarning warning) {
        this.getWarnings().add(warning);
    }

    public Map<String, Integer> getEntityCountByOboIDMap() {
        return this.entityCountByOboIDMap;
    }

    public Collection<TermSubset> getCategories() {
        return this.categories;
    }

    public void setCategories(Collection<TermSubset> categories) {
        this.categories = categories;
    }

    public void addCategory(String cat) {
        this.categories.add(this.session.getCategory(cat));
    }

    public void addCategory(TermSubset cat) {
        this.categories.add(cat);
    }

    public void setCategory(TermSubset cat) {
        this.categories = new HashSet<TermSubset>();
        this.addCategory(cat);
    }

    public IDFileMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    public void setFileMetadata(IDFileMetadata fileMetadata) {
        this.fileMetadata = fileMetadata;
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
        reasoner.setLinkDatabase(this.session.getLinkDatabase());
    }

    public Collection<OBOProperty> getPropertiesToTraverse() {
        return this.propertiesToTraverse;
    }

    public void setPropertiesToTraverse(Collection<OBOProperty> propertiesToTraverse) {
        this.propertiesToTraverse = propertiesToTraverse;
    }

    public void addPropertyToTraverse(String propID) {
        OBOProperty prop = (OBOProperty)this.session.getObject(propID);
        this.addPropertyToTraverse(prop);
    }

    public void addPropertyToTraverse(OBOProperty prop) {
        if (this.propertiesToTraverse == null) {
            this.propertiesToTraverse = new HashSet<OBOProperty>();
        }
        this.propertiesToTraverse.add(prop);
    }

    public final boolean isAutoReplaceConsiderTags() {
        return this.autoReplaceConsiderTags;
    }

    public final void setAutoReplaceConsiderTags(boolean autoReplaceConsiderTags) {
        this.autoReplaceConsiderTags = autoReplaceConsiderTags;
    }

    public IDMapper() {
    }

    public IDMapper(OBOSession session, ReasonedLinkDatabase linkDatabase) {
        this.session = session;
        this.reasoner = linkDatabase;
    }

    private Collection<LinkedObject> getAncestorObjects(OBOObject object) {
        if (this.reasoner != null) {
            HashSet<LinkedObject> pobjs = new HashSet<LinkedObject>();
            for (Link link : this.reasoner.getParents(object)) {
                if (this.propertiesToTraverse != null && this.propertiesToTraverse.size() != 0 && !link.getType().equals(OBOProperty.IS_A) && !this.propertiesToTraverse.contains(link.getType())) continue;
                pobjs.add(link.getParent());
            }
            return pobjs;
        }
        return TermUtil.getAncestors(object);
    }

    public Collection<OBOObject> mapIdentifierViaFilter(String id, boolean countMode) {
        this.inputParams = new MapperInputParams(!countMode, this.filter);
        if (!this.cacheMap.containsKey(this.inputParams)) {
            logger.info((Object)("creating new cache for " + this.inputParams));
            this.cacheMap.put(this.inputParams, new HashMap());
        } else {
            logger.info((Object)("reusing cache for " + this.inputParams));
        }
        Map<String, Collection<OBOObject>> map = this.cacheMap.get(this.inputParams);
        if (map.containsKey(id)) {
            return map.get(id);
        }
        logger.info((Object)(id + " not in cache: " + map));
        Collection<OBOObject> filteredMappedObjs = this.mapIdentifierViaFilterUncached(id, countMode);
        map.put(id, filteredMappedObjs);
        return filteredMappedObjs;
    }

    private Collection<OBOObject> mapIdentifierViaFilterUncached(String id, boolean countMode) {
        HashSet mappedIDs = new HashSet();
        HashSet<OBOObject> filteredMappedObjs = new HashSet<OBOObject>();
        OBOObject obj = (OBOObject)this.session.getObject(id);
        if (obj == null || obj.isObsolete()) {
            IDWarning warning = IDUtil.getWarning(id, false, this.session, this.getSecondaryIDMap());
            if (warning != null) {
                this.addWarning(warning);
                Collection<IDResolution> resols = warning.getResolutions();
                HashSet<OBOObject> replacementObjs = new HashSet<OBOObject>();
                for (IDResolution resol : resols) {
                    if (resol.requiresUserIntervention() && !this.isAutoReplaceConsiderTags()) continue;
                    replacementObjs.addAll(this.mapIdentifierViaFilter(resol.getReplacementID(), countMode));
                }
                return replacementObjs;
            }
            return filteredMappedObjs;
        }
        HashSet<OBOObject> mappedObjs = new HashSet<OBOObject>();
        for (LinkedObject pobj : this.getAncestorObjects(obj)) {
            mappedObjs.add((OBOObject)pobj);
        }
        mappedObjs.add(obj);
        for (OBOObject mappedObj : mappedObjs) {
            if (!this.filter.satisfies(mappedObj)) continue;
            filteredMappedObjs.add(mappedObj);
        }
        if (!countMode) {
            HashSet<OBOObject> generalObjs = new HashSet<OBOObject>();
            for (OBOObject mappedObj : filteredMappedObjs) {
                boolean isSpecific = true;
                for (LinkedObject p : this.getAncestorObjects(mappedObj)) {
                    if (p.equals(mappedObj) || !filteredMappedObjs.contains(p)) continue;
                    logger.info((Object)(p + " is more general than " + mappedObj + " [in set], so I am removing"));
                    generalObjs.add((OBOObject)p);
                }
            }
            filteredMappedObjs.removeAll(generalObjs);
        }
        return filteredMappedObjs;
    }

    public Collection<OBOObject> mapIdentifierViaCategories(String id, boolean countMode) {
        LinkedList filters = new LinkedList();
        for (TermSubset cat : this.categories) {
            ObjectFilterImpl f = new ObjectFilterImpl();
            f.setCriterion(new SubsetSearchCriterion());
            f.setValue(cat.getName());
            filters.add(f);
        }
        this.filter = FilterUtil.mergeFilters(filters);
        return this.mapIdentifierViaFilter(id, countMode);
    }

    public SimpleAnnotation parseAndFilterLine(String line) {
        String qual;
        if (line.substring(0, 1).equals(this.fileMetadata.getCommentCharacter())) {
            return null;
        }
        String[] colVals = line.split(this.fileMetadata.getColumnDelimiter(), -1);
        if (colVals.length < this.fileMetadata.getMinCols()) {
            return null;
        }
        int ENTITY = this.fileMetadata.getEntityColumn() - 1;
        int ID = this.fileMetadata.getOboIDColumn() - 1;
        if (this.fileMetadata.getQualifierColumn() > 0 && !(qual = colVals[this.fileMetadata.getQualifierColumn() - 1]).equals("")) {
            return null;
        }
        SimpleAnnotation annot = new SimpleAnnotation(colVals[ENTITY], colVals[ID]);
        annot.setColVals(colVals);
        return annot;
    }

    public void calcEntityCountByOboID(Map<String, Collection<String>> e2ids) {
        this.entityCountByOboIDMap = new HashMap<String, Integer>();
        for (String entityID : e2ids.keySet()) {
            HashSet<String> allMappedIDsForEntity = new HashSet<String>();
            for (String oboID : e2ids.get(entityID)) {
                Collection<OBOObject> objs = this.mapIdentifierViaCategories(oboID, true);
                for (OBOObject obj : objs) {
                    allMappedIDsForEntity.add(obj.getID());
                }
            }
            for (String mappedID : allMappedIDsForEntity) {
                if (!this.entityCountByOboIDMap.containsKey(mappedID)) {
                    this.entityCountByOboIDMap.put(mappedID, 1);
                    continue;
                }
                this.entityCountByOboIDMap.put(mappedID, this.entityCountByOboIDMap.get(mappedID) + 1);
            }
        }
    }

    public Map<String, Collection<String>> simpleAnnotationFileParse(String inputPath) throws IOException {
        FileReader fr = new FileReader(inputPath);
        LineNumberReader lnr = new LineNumberReader(fr);
        HashMap<String, Collection<String>> e2ids = new HashMap<String, Collection<String>>();
        String line = lnr.readLine();
        while (line != null) {
            SimpleAnnotation annot = this.parseAndFilterLine(line);
            if (annot != null) {
                String[] colVals = annot.getColVals();
                String oboID = annot.getOboID();
                String entityID = annot.getEntityID();
                if (!e2ids.containsKey(entityID)) {
                    e2ids.put(entityID, new HashSet());
                }
                ((Collection)e2ids.get(entityID)).add(oboID);
            }
            line = lnr.readLine();
        }
        return e2ids;
    }

    public void reset() {
        this.setWarnings(new HashSet<IDWarning>());
        this.cacheMap = new HashMap<MapperInputParams, Map<String, Collection<OBOObject>>>();
    }

    public final class IDFileMetadata {
        private int entityColumn = 2;
        private int oboIDColumn = 5;
        private int qualifierColumn = 4;
        private int minCols = 6;
        private String columnDelimiter = "\t";
        private String commentCharacter = "!";

        public int getEntityColumn() {
            return this.entityColumn;
        }

        public void setEntityColumn(int entityColumn) {
            this.entityColumn = entityColumn;
        }

        public int getOboIDColumn() {
            return this.oboIDColumn;
        }

        public void setOboIDColumn(int oboIDColumn) {
            this.oboIDColumn = oboIDColumn;
        }

        public int getQualifierColumn() {
            return this.qualifierColumn;
        }

        public void setQualifierColumn(int qualifierColumn) {
            this.qualifierColumn = qualifierColumn;
        }

        public final int getMinCols() {
            return this.minCols;
        }

        public final void setMinCols(int minCols) {
            this.minCols = minCols;
        }

        public String getColumnDelimiter() {
            return this.columnDelimiter;
        }

        public void setColumnDelimiter(String columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
        }

        public final String getCommentCharacter() {
            return this.commentCharacter;
        }

        public final void setCommentCharacter(String commentCharacter) {
            this.commentCharacter = commentCharacter;
        }
    }

    public class SimpleAnnotation {
        private String entityID;
        private String oboID;
        private String[] colVals;

        public SimpleAnnotation(String entityID, String oboID) {
            this.oboID = oboID;
            this.entityID = entityID;
        }

        public final String getEntityID() {
            return this.entityID;
        }

        public final String getOboID() {
            return this.oboID;
        }

        public String[] getColVals() {
            return this.colVals;
        }

        public void setColVals(String[] colVals) {
            this.colVals = colVals;
        }
    }

    public final class MapperInputParams {
        private final boolean isSpecificOnly;
        private final Filter filter;

        public MapperInputParams(boolean isSpecificOnly, Filter filter) {
            this.isSpecificOnly = isSpecificOnly;
            this.filter = filter;
        }

        public final Filter getFilter() {
            return this.filter;
        }

        public final boolean isSpecificOnly() {
            return this.isSpecificOnly;
        }

        public final String toString() {
            String s = this.isSpecificOnly ? "Specific-only" : "Include-ancestors";
            return s + this.filter.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof MapperInputParams) {
                return o.toString().equals(this.toString());
            }
            return false;
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }
    }
}

