/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.bbop.util.ObjectUtil;
import org.bbop.util.VectorFilter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.DestroyObjectHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.SecondaryIDHistoryItem;
import org.obo.identifier.DefaultIDGenerator;
import org.obo.identifier.DefaultIDResolution;
import org.obo.identifier.DefaultIDWarning;
import org.obo.identifier.DefaultLinkIDWarning;
import org.obo.identifier.IDGenerator;
import org.obo.identifier.IDProfile;
import org.obo.identifier.IDResolution;
import org.obo.identifier.IDRule;
import org.obo.identifier.IDWarning;
import org.obo.identifier.LinkIDResolution;
import org.obo.identifier.LinkIDWarning;
import org.obo.identifier.UnresolvedIDsException;
import org.obo.util.HTMLUtil;
import org.obo.util.HistoryUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDUtil {
    protected static final Logger logger = Logger.getLogger(IDUtil.class);

    public static List parseVarString(String s) {
        LinkedList<Object> out = new LinkedList<Object>();
        if (s == null) {
            return out;
        }
        StringBuffer buffer = new StringBuffer();
        boolean inVar = false;
        boolean inParens = false;
        boolean inQuotes = false;
        Variable currentVariable = null;
        for (int i = 0; i < s.length(); ++i) {
            if (!inParens && s.charAt(i) == '$') {
                if (inVar) {
                    if (currentVariable == null) {
                        currentVariable = new Variable(buffer.toString());
                    }
                    out.add(currentVariable);
                    inVar = false;
                    inParens = false;
                    currentVariable = null;
                } else {
                    out.add(buffer.toString());
                    inVar = true;
                    inParens = false;
                }
                buffer = new StringBuffer();
                continue;
            }
            if (inVar && !inParens && s.charAt(i) == '(') {
                currentVariable = new Variable(buffer.toString());
                buffer = new StringBuffer();
                inParens = true;
                continue;
            }
            if (inVar && inParens && s.charAt(i) == ')') {
                currentVariable.addParam(buffer.toString().trim());
                buffer = new StringBuffer();
                inParens = false;
                continue;
            }
            if (inVar && inParens && s.charAt(i) == ',') {
                currentVariable.addParam(buffer.toString().trim());
                buffer = new StringBuffer();
                continue;
            }
            if (s.charAt(i) == '\\') {
                if (i + 1 >= s.length() || s.charAt(i + 1) != '$' && s.charAt(i + 1) != ')' && s.charAt(i + 1) != '(' && s.charAt(i + 1) != ',') continue;
                ++i;
                buffer.append('$');
                continue;
            }
            buffer.append(s.charAt(i));
        }
        if (inVar || inParens || inQuotes || currentVariable != null) {
            return null;
        }
        if (buffer.length() > 0) {
            out.add(buffer.toString());
        }
        return out;
    }

    public static Map createIDRemapping(HistoryList list) {
        HashMap<String, HashSet<String>> out = new HashMap<String, HashSet<String>>();
        VectorFilter destroyFilter = new VectorFilter(){

            public boolean satisfies(Object o) {
                return o instanceof DestroyObjectHistoryItem;
            }
        };
        final HashSet<String> destroyedIDs = new HashSet<String>();
        Collection matches = HistoryUtil.findMatchingItems(list, destroyFilter);
        for (DestroyObjectHistoryItem item : matches) {
            destroyedIDs.add(item.getTarget());
        }
        VectorFilter secondaryFilter = new VectorFilter(){

            public boolean satisfies(Object o) {
                return o instanceof SecondaryIDHistoryItem && destroyedIDs.contains(((SecondaryIDHistoryItem)o).getSecondaryID());
            }
        };
        matches = HistoryUtil.findMatchingItems(list, secondaryFilter);
        for (SecondaryIDHistoryItem item : matches) {
            HashSet<String> c = (HashSet<String>)out.get(item.getSecondaryID());
            if (c == null) {
                c = new HashSet<String>();
                out.put(item.getSecondaryID(), c);
            }
            c.add(item.getTarget());
        }
        return out;
    }

    public static boolean isLegalID(String id) {
        for (int i = 0; i < id.length(); ++i) {
            if (!Character.isWhitespace(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] fetchIDs(IDGenerator idGen, OBOSession session, LinkedObject parent, int size) {
        String[] out = new String[size];
        HashSet<String> reserved = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            out[i] = IDUtil.fetchID(idGen, session, parent, reserved, false);
            reserved.add(out[i]);
        }
        return out;
    }

    public static String fetchID(IDGenerator idGen, OBOSession session, LinkedObject parent) {
        return IDUtil.fetchID(idGen, session, parent, null);
    }

    public static String fetchID(IDGenerator idGen, OBOSession session, LinkedObject parent, Collection<String> reservedIDs) {
        return IDUtil.fetchID(idGen, session, parent, reservedIDs, false);
    }

    public static String fetchID(IDGenerator idGen, OBOSession session, LinkedObject parent, Collection<String> reservedIDs, boolean temporary) {
        return idGen.generateID(session, parent, reservedIDs, temporary);
    }

    public static String fetchTemporaryID(OBOSession session) {
        return IDUtil.fetchTemporaryID(new DefaultIDGenerator(), session);
    }

    public static String fetchTemporaryID(IDGenerator idGen, OBOSession session) {
        return IDUtil.fetchID(idGen, session, null, null, true);
    }

    public static boolean equals(IDProfile a, IDProfile b) {
        boolean failed = false;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return true;
        }
        if (a.getRules().size() != b.getRules().size() && a.getRules().size() != 0) {
            failed = true;
        } else {
            for (IDRule rule : a.getRules()) {
                boolean found = false;
                for (IDRule rule2 : b.getRules()) {
                    if (!rule.equals(rule2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                failed = true;
                break;
            }
        }
        if (!ObjectUtil.equals((Object)a.getDefaultRule(), (Object)b.getDefaultRule())) {
            failed = true;
        }
        return !failed;
    }

    public static String getDescription(LinkIDWarning warning, boolean html) {
        StringBuffer buffer = new StringBuffer();
        if (html) {
            buffer.append("<html>");
        }
        buffer.append("The term " + HTMLUtil.getHTMLLink(warning.getLink().getChild(), html));
        if (warning.getParentWarning() != null) {
            if (warning.getParentWarning().getType().equals((Object)IDWarning.WarningType.DANGLING_ID)) {
                buffer.append(" links to the dangling identifier " + (html ? "<i>" : "") + warning.getLink().getParent().getID() + (html ? "</i>" : ""));
            } else if (warning.getParentWarning().getType().equals((Object)IDWarning.WarningType.SECONDARY_ID)) {
                buffer.append(" links to the secondary identifier " + warning.getLink().getParent().getID());
            } else if (warning.getParentWarning().getType().equals((Object)IDWarning.WarningType.OBSOLETE_ID)) {
                buffer.append(" links to the obsolete term " + HTMLUtil.getHTMLLink(warning.getLink().getParent(), html));
            }
        }
        if (html) {
            buffer.append("</html>");
        }
        return buffer.toString();
    }

    public static boolean hasIDIssues(OBOSession session) {
        try {
            IDUtil.updateIDs(session, new ArrayList<LinkIDResolution>(), false);
            return false;
        }
        catch (UnresolvedIDsException e) {
            return true;
        }
    }

    public static List<HistoryItem> updateIDs(OBOSession session, Collection<LinkIDResolution> resolutions, boolean applyImmediately) throws UnresolvedIDsException {
        return IDUtil.updateIDs(session, resolutions, applyImmediately, false);
    }

    public static MultiMap<String, IdentifiedObject> getSecondaryIDMap(OBOSession session) {
        MultiHashMap secondaryIDMap = new MultiHashMap();
        for (IdentifiedObject io : session.getObjects()) {
            if (TermUtil.isDangling(io) || !(io instanceof MultiIDObject)) continue;
            for (String id : ((MultiIDObject)io).getSecondaryIDs()) {
                secondaryIDMap.add((Object)id, (Object)io);
            }
        }
        return secondaryIDMap;
    }

    public static List<HistoryItem> updateIDs(OBOSession session, Collection<LinkIDResolution> resolutions, boolean applyImmediately, boolean applyDespiteExceptions) throws UnresolvedIDsException {
        MultiHashMap secondaryIDMap = new MultiHashMap();
        for (IdentifiedObject io : session.getObjects()) {
            if (TermUtil.isDangling(io) || !(io instanceof MultiIDObject)) continue;
            for (String id : ((MultiIDObject)io).getSecondaryIDs()) {
                secondaryIDMap.add((Object)id, (Object)io);
            }
        }
        MultiHashMap resolutionMap = new MultiHashMap();
        if (resolutions != null) {
            for (LinkIDResolution r : resolutions) {
                resolutionMap.add((Object)r.getLink(), (Object)r);
            }
        }
        LinkedList<LinkIDWarning> warnings = new LinkedList<LinkIDWarning>();
        Iterator<Link> linkIterator = TermUtil.getAllLinks(session.getLinkDatabase());
        while (linkIterator.hasNext()) {
            boolean typeProblem;
            Link link = linkIterator.next();
            LinkIDWarning warning = IDUtil.getWarning(link, session, (MultiMap<String, IdentifiedObject>)secondaryIDMap);
            if (warning == null) continue;
            Collection linkResolutions = (Collection)resolutionMap.get((Object)link);
            boolean parentProblem = warning.getParentWarning() != null;
            boolean bl = typeProblem = warning.getTypeWarning() != null;
            if (!parentProblem && !typeProblem) continue;
            for (LinkIDResolution res : linkResolutions) {
                if (res.getParentResolution() == null && res.getTypeResolution() == null) {
                    parentProblem = false;
                    typeProblem = false;
                } else {
                    if (warning.getParentWarning() != null && res.getParentResolution() != null) {
                        parentProblem = false;
                    }
                    if (warning.getTypeWarning() != null && res.getTypeResolution() != null) {
                        typeProblem = false;
                    }
                }
                if (typeProblem && parentProblem) continue;
                break;
            }
            if (!parentProblem && !typeProblem) continue;
            warnings.add(warning);
        }
        if (!applyDespiteExceptions && warnings.size() > 0) {
            throw new UnresolvedIDsException(warnings);
        }
        LinkedList<HistoryItem> historyItems = new LinkedList<HistoryItem>();
        for (LinkIDResolution resolution : resolutions) {
            IdentifiedObject io;
            if (resolution.getParentResolution() == null && resolution.getTypeResolution() == null) continue;
            DeleteLinkHistoryItem delItem = new DeleteLinkHistoryItem(resolution.getLink());
            Link newLink = (Link)resolution.getLink().clone();
            if (resolution.getParentResolution() != null && (io = session.getObject(resolution.getParentResolution().getReplacementID())) instanceof LinkedObject) {
                newLink.setParent((LinkedObject)io);
            }
            if (resolution.getTypeResolution() != null && (io = session.getObject(resolution.getTypeResolution().getReplacementID())) instanceof OBOProperty) {
                newLink.setType((OBOProperty)io);
            }
            CreateLinkHistoryItem addItem = new CreateLinkHistoryItem(newLink);
            historyItems.add(delItem);
            historyItems.add(addItem);
            if (!applyImmediately) continue;
            LinkedObject child = resolution.getLink().getChild();
            child.removeParent(resolution.getLink());
            child.addParent(newLink);
        }
        if (applyDespiteExceptions && warnings.size() > 0) {
            throw new UnresolvedIDsException(warnings);
        }
        return historyItems;
    }

    public static IDWarning getWarning(String id, boolean isDangling, OBOSession session, Map<String, Collection<IdentifiedObject>> multiIDMap) {
        IdentifiedObject obj = session.getObject(id);
        if (TermUtil.isObsolete(obj)) {
            DefaultIDResolution resolution;
            DefaultIDResolution resolution2;
            IDWarning rw;
            boolean isReplacementDangling;
            LinkedList<IDResolution> resolutions = new LinkedList<IDResolution>();
            for (ObsoletableObject oo : ((ObsoletableObject)obj).getConsiderReplacements()) {
                isReplacementDangling = session.getObject(oo.getID()) == null;
                rw = IDUtil.getWarning(oo.getID(), isReplacementDangling, session, multiIDMap);
                if (rw == null) {
                    resolution2 = new DefaultIDResolution(id, oo.getID(), true);
                    resolutions.add(resolution2);
                    continue;
                }
                for (IDResolution r : rw.getResolutions()) {
                    resolution = new DefaultIDResolution(id, r.getReplacementID(), true);
                    resolutions.add(resolution);
                }
            }
            for (ObsoletableObject oo : ((ObsoletableObject)obj).getReplacedBy()) {
                isReplacementDangling = session.getObject(oo.getID()) == null;
                rw = IDUtil.getWarning(oo.getID(), isReplacementDangling, session, multiIDMap);
                if (rw == null) {
                    resolution2 = new DefaultIDResolution(id, oo.getID(), false);
                    resolutions.add(resolution2);
                    continue;
                }
                for (IDResolution r : rw.getResolutions()) {
                    resolution = new DefaultIDResolution(id, r.getReplacementID(), r.requiresUserIntervention());
                    resolutions.add(resolution);
                }
            }
            DefaultIDWarning warning = new DefaultIDWarning(id, resolutions, IDWarning.WarningType.OBSOLETE_ID);
            return warning;
        }
        if (multiIDMap.containsKey(id)) {
            Collection<IdentifiedObject> terms = multiIDMap.get(id);
            LinkedList<IDResolution> resolutions = new LinkedList<IDResolution>();
            for (IdentifiedObject io : terms) {
                boolean isReplacementDangling = session.getObject(io.getID()) == null;
                IDWarning rw = IDUtil.getWarning(io.getID(), isReplacementDangling, session, multiIDMap);
                if (rw == null) {
                    DefaultIDResolution resolution = new DefaultIDResolution(id, io.getID(), terms.size() > 1);
                    resolutions.add(resolution);
                    continue;
                }
                for (IDResolution r : rw.getResolutions()) {
                    DefaultIDResolution resolution = new DefaultIDResolution(id, r.getReplacementID(), terms.size() > 1 || r.requiresUserIntervention());
                    resolutions.add(resolution);
                }
            }
            DefaultIDWarning warning = new DefaultIDWarning(id, resolutions, IDWarning.WarningType.SECONDARY_ID);
            return warning;
        }
        if (TermUtil.isDangling(obj)) {
            DefaultIDResolution resolution = new DefaultIDResolution(id, id, false);
            DefaultIDWarning warning = new DefaultIDWarning(id, Collections.singleton(resolution), IDWarning.WarningType.DANGLING_ID);
            return warning;
        }
        return null;
    }

    protected static LinkIDWarning getWarning(Link link, OBOSession session, MultiMap<String, IdentifiedObject> multiIDMap) {
        IDWarning typeWarning = IDUtil.getWarning(link.getType().getID(), TermUtil.isDangling(link.getType()), session, multiIDMap);
        IDWarning parentWarning = IDUtil.getWarning(link.getParent().getID(), TermUtil.isDangling(link.getParent()), session, multiIDMap);
        if (typeWarning == null && parentWarning == null) {
            return null;
        }
        return new DefaultLinkIDWarning(link, parentWarning, typeWarning);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Variable {
        protected String name;
        protected List<String> params = new ArrayList<String>();

        public Variable(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        public List<String> getParams() {
            return this.params;
        }

        public String toString() {
            return "[variable: " + this.name + ", params: " + this.params + "]";
        }
    }

    public static class VariableValue {
        protected Variable v;
        protected String value;

        public VariableValue(Variable v, String value) {
            this.v = v;
            this.value = value;
        }

        public Variable getVariable() {
            return this.v;
        }

        public String getValue() {
            return this.value;
        }
    }
}

