/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.util.AbstractTaskDelegate;
import org.bbop.util.EmptyIterator;
import org.bbop.util.IteratorFactory;
import org.bbop.util.MultiHashMap;
import org.bbop.util.ObjectUtil;
import org.bbop.util.SuperIterator;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.DatatypeValue;
import org.obo.datamodel.IdentifiableObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Impliable;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.RootAlgorithm;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.Value;
import org.obo.datamodel.impl.DanglingClassImpl;
import org.obo.datamodel.impl.DanglingInstanceImpl;
import org.obo.datamodel.impl.DanglingLinkImpl;
import org.obo.datamodel.impl.DanglingPropertyImpl;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.filters.LinkFilter;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.util.ReasonerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermUtil {
    protected static final Logger logger = Logger.getLogger(TermUtil.class);

    private TermUtil() {
    }

    public static LinkedObject cloneParentTree(LinkedObject term) {
        if (term.getParents().size() == 0) {
            return term;
        }
        OBOClass newRoot = null;
        Iterator<LinkedObject> it = TermUtil.getAncestors(term).iterator();
        HashMap<OBOClass, OBOClass> newTermHash = new HashMap<OBOClass, OBOClass>();
        HashMap<OBOClass, OBOClass> oldTermHash = new HashMap<OBOClass, OBOClass>();
        while (it.hasNext()) {
            OBOClass originalTerm = (OBOClass)it.next();
            OBOClass newTerm = (OBOClass)originalTerm.clone();
            if (originalTerm.getID().equals(term.getID())) continue;
            if (originalTerm.getParents().size() == 0) {
                newRoot = newTerm;
            }
            newTermHash.put(newTerm, originalTerm);
            oldTermHash.put(originalTerm, newTerm);
        }
        for (OBOClass newTerm : newTermHash.keySet()) {
            OBORestrictionImpl trNew;
            OBOClass originalTerm = (OBOClass)newTermHash.get(newTerm);
            newTerm.getParents().clear();
            newTerm.getChildren().clear();
            for (Link tr : originalTerm.getChildren()) {
                OBOClass newChild = (OBOClass)oldTermHash.get(tr.getChild());
                if (newChild != null) {
                    trNew = new OBORestrictionImpl((LinkedObject)newChild, newTerm, tr.getType());
                    newTerm.atomicAddChild(trNew);
                    continue;
                }
                if (tr.getChild() != term) continue;
                trNew = new OBORestrictionImpl(term, newTerm, tr.getType());
                newTerm.atomicAddChild(trNew);
            }
            for (Link tr : originalTerm.getParents()) {
                OBOClass newParent = (OBOClass)oldTermHash.get(tr.getParent());
                trNew = new OBORestrictionImpl((LinkedObject)newTerm, newParent, tr.getType());
                newTerm.atomicAddParent(trNew);
            }
        }
        return newRoot;
    }

    public static OBOSession getSession(String path) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(path);
        OBOSession session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        return session;
    }

    public static Map<String, IdentifiedObject> createIDMap(Collection<? extends IdentifiedObject> c) {
        HashMap<String, IdentifiedObject> out = new HashMap<String, IdentifiedObject>();
        for (IdentifiedObject identifiedObject : c) {
            out.put(identifiedObject.getID(), identifiedObject);
        }
        return out;
    }

    public static void detectRoots(Collection<LinkedObject> outSet, LinkDatabase linkDatabase, Collection<IdentifiedObject> objects, RootAlgorithm algorithm) {
        algorithm.setLinkDatabase(linkDatabase);
        for (IdentifiedObject io : objects) {
            LinkedObject lo;
            if (!(io instanceof LinkedObject) || !algorithm.isRoot(lo = (LinkedObject)io)) continue;
            outSet.add((LinkedObject)io);
        }
    }

    public static void detectRoots(Set<LinkedObject> outSet, LinkDatabase linkDatabase, RootAlgorithm rootAlgorithm) {
        TermUtil.detectRoots(outSet, linkDatabase, linkDatabase.getObjects(), rootAlgorithm);
    }

    public static Collection<LinkedObject> getAncestors(LinkedObject term) {
        return TermUtil.getAncestors(term, false);
    }

    public static Collection<LinkedObject> getAncestors(LinkedObject term, boolean includeSelf) {
        return TermUtil.getAncestors(term, null, includeSelf);
    }

    public static Collection<LinkedObject> getAncestors(LinkedObject term, LinkDatabase linkDatabase, boolean includeSelf) {
        AncestorTask task = TermUtil.getAncestors(term, linkDatabase);
        task.execute();
        Collection out = (Collection)task.getResults();
        if (includeSelf) {
            out.add(term);
        }
        return out;
    }

    public static AncestorTask getAncestors(LinkedObject term, LinkDatabase linkDatabase) {
        return new AncestorTask(linkDatabase, term, null);
    }

    public static boolean isAncestor(LinkedObject term, LinkedObject ancestor, LinkDatabase linkDatabase) {
        return TermUtil.getAncestors(term, linkDatabase, true).contains(ancestor);
    }

    protected static AncestorTask getAncestors(LinkedObject term, LinkDatabase linkDatabase, Map<LinkedObject, Collection<LinkedObject>> memoizeTable) {
        return new AncestorTask(linkDatabase, term, memoizeTable);
    }

    public static int getChildCount(LinkDatabase linkDatabase, LinkedObject lo) {
        return linkDatabase.getChildren(lo).size();
    }

    public static Collection<LinkedObject> getDescendants(LinkedObject term) {
        return TermUtil.getDescendants(term, false);
    }

    public static Collection<LinkedObject> getDescendants(LinkedObject term, boolean includeSelf) {
        return TermUtil.getDescendants(term, null, includeSelf);
    }

    public static Collection<LinkedObject> getDescendants(LinkedObject term, LinkDatabase linkDatabase, boolean includeSelf) {
        DescendantTask task = new DescendantTask(linkDatabase, term, null);
        task.execute();
        Collection out = (Collection)task.getResults();
        if (includeSelf) {
            out.add(term);
        }
        return out;
    }

    protected static Object getFirst(Collection c) {
        Iterator it = c.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static int getObjectCount(LinkDatabase linkDatabase) {
        return linkDatabase.getObjects().size();
    }

    public static Collection<ObsoletableObject> getObsoletes(LinkDatabase session) {
        LinkedList<ObsoletableObject> out = new LinkedList<ObsoletableObject>();
        for (IdentifiedObject io : session.getObjects()) {
            if (!TermUtil.isObsolete(io)) continue;
            out.add((ObsoletableObject)io);
        }
        return out;
    }

    public static Collection<ObsoletableObject> getObsoletes(OBOSession session) {
        return TermUtil.getObsoletes(session.getLinkDatabase());
    }

    public static Collection<DanglingObject> getDanglingObjects(LinkDatabase session) {
        LinkedList<DanglingObject> out = new LinkedList<DanglingObject>();
        for (IdentifiedObject io : session.getObjects()) {
            if (!TermUtil.isDangling(io)) continue;
            out.add((DanglingObject)io);
        }
        return out;
    }

    public static int getParentCount(LinkDatabase linkDatabase, LinkedObject lo) {
        return linkDatabase.getParents(lo).size();
    }

    public static Collection<LinkedObject> getParentsByType(LinkedObject lo, OBOProperty type) {
        HashSet<LinkedObject> parents = new HashSet<LinkedObject>();
        for (Link link : lo.getParents()) {
            if (!link.getType().equals(type)) continue;
            parents.add(link.getParent());
        }
        return parents;
    }

    public static Collection<LinkedObject> getParents(LinkedObject lo) {
        HashSet<LinkedObject> parents = new HashSet<LinkedObject>();
        for (Link link : lo.getParents()) {
            parents.add(link.getParent());
        }
        return parents;
    }

    public static Collection<LinkedObject> getChildren(LinkedObject lo) {
        HashSet<LinkedObject> children = new HashSet<LinkedObject>();
        for (Link link : lo.getChildren()) {
            children.add(link.getParent());
        }
        return children;
    }

    public static Object getPropValue(Instance instance, OBOProperty property) {
        Collection c = TermUtil.getPropValues(instance, property);
        return TermUtil.getFirst(c);
    }

    public static <T> T getPropValue(Instance instance, OBOProperty property, Class<T> expectedClass, boolean failOnMultipleValues) {
        Collection values = TermUtil.getPropValues(instance, property);
        if (values.size() == 0) {
            return null;
        }
        if (failOnMultipleValues && values.size() > 1) {
            throw new RuntimeException("Too many values for " + property.getID() + " relationship for instance " + instance.getID());
        }
        Object value = TermUtil.getFirst(values);
        if (!expectedClass.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("Got object " + value + " of type " + value.getClass() + " for property " + property.getID() + " of instance " + instance.getID() + ", but expected object of type " + expectedClass);
        }
        return (T)value;
    }

    public static Collection getPropValues(Instance instance, OBOProperty property) {
        Collection<Value<?>> values = instance.getValues(property);
        LinkedList<Object> list = new LinkedList<Object>();
        for (Value<?> v : values) {
            if (v.getType() instanceof Datatype && v instanceof DatatypeValue) {
                Object o = ((Datatype)v.getType()).getValue(((DatatypeValue)v).getValue());
                list.add(o);
                continue;
            }
            list.add(v);
        }
        return list;
    }

    public static Collection<OBOProperty> getRelationshipTypes(LinkDatabase linkDatabase) {
        LinkedList<OBOProperty> out = new LinkedList<OBOProperty>();
        for (IdentifiedObject io : linkDatabase.getObjects()) {
            if (!TermUtil.isProperty(io) || TermUtil.isObsolete(io)) continue;
            out.add((OBOProperty)io);
        }
        return out;
    }

    public static Collection<OBOProperty> getRelationshipTypes(OBOSession session) {
        return TermUtil.getRelationshipTypes(session.getLinkDatabase());
    }

    public static LinkedObject getRoot(LinkedObject obj) {
        return TermUtil.getRoot(obj, DefaultLinkDatabase.getDefault(), RootAlgorithm.GREEDY);
    }

    public static LinkedObject getRoot(LinkedObject obj, LinkDatabase linkDatabase, RootAlgorithm rootAlgorithm) {
        rootAlgorithm.setLinkDatabase(linkDatabase);
        if (rootAlgorithm.isRoot(obj)) {
            return obj;
        }
        for (Link o : linkDatabase.getParents(obj)) {
            Link parent = o;
            LinkedObject root = TermUtil.getRoot(parent.getParent(), linkDatabase, rootAlgorithm);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    public static Collection<OBOClass> getRoots(LinkDatabase linkDatabase) {
        Collection<LinkedObject> c = TermUtil.getRoots(RootAlgorithm.GREEDY, linkDatabase, true, false, false, false);
        return c;
    }

    public static Collection<LinkedObject> getRoots(LinkDatabase linkDatabase, boolean includeTerms, boolean includeProperties, boolean includeObsoletes, boolean includeInstances) {
        return TermUtil.getRoots(RootAlgorithm.GREEDY, linkDatabase, includeTerms, includeProperties, includeObsoletes, includeInstances);
    }

    public static Collection<OBOClass> getRoots(OBOSession session) {
        return TermUtil.getRoots(session.getLinkDatabase());
    }

    public static Collection<LinkedObject> getRoots(RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase) {
        return TermUtil.getRoots(rootAlgorithm, linkDatabase, true, false, false, false);
    }

    public static Collection<LinkedObject> getRoots(RootAlgorithm rootAlgorithm, LinkDatabase linkDatabase, boolean includeTerms, boolean includeProperties, boolean includeObsoletes, boolean includeInstances) {
        rootAlgorithm.setLinkDatabase(linkDatabase);
        LinkedList<LinkedObject> out = new LinkedList<LinkedObject>();
        for (IdentifiedObject io : linkDatabase.getObjects()) {
            LinkedObject lo;
            if (!(io instanceof LinkedObject) || !includeProperties && TermUtil.isProperty(io) || !includeObsoletes && TermUtil.isObsolete(io) || !includeInstances && TermUtil.isInstance(io) || !includeTerms && TermUtil.isClass(io) || !rootAlgorithm.isRoot(lo = (LinkedObject)io)) continue;
            out.add(lo);
        }
        return out;
    }

    public static Collection<OBOClass> getTerms(LinkDatabase linkDatabase) {
        LinkedList<OBOClass> out = new LinkedList<OBOClass>();
        for (IdentifiedObject io : linkDatabase.getObjects()) {
            if (!TermUtil.isClass(io) || TermUtil.isObsolete(io)) continue;
            out.add((OBOClass)io);
        }
        return out;
    }

    public static Collection<OBOClass> getTerms(OBOSession session) {
        return TermUtil.getTerms(session.getLinkDatabase());
    }

    public static Collection<Instance> getInstances(LinkDatabase linkDatabase) {
        LinkedList<Instance> out = new LinkedList<Instance>();
        for (IdentifiedObject io : linkDatabase.getObjects()) {
            if (!TermUtil.isInstance(io)) continue;
            out.add((Instance)io);
        }
        return out;
    }

    public static Collection<Instance> getInstances(OBOSession session) {
        return TermUtil.getInstances(session.getLinkDatabase());
    }

    public static boolean hasAncestor(LinkedObject child, LinkedObject ancestor) {
        boolean out = TermUtil.hasAncestor(new DefaultLinkDatabase(null), child, ancestor, new HashSet<LinkedObject>());
        return out;
    }

    protected static boolean hasAncestor(LinkDatabase linkDatabase, LinkedObject child, LinkedObject ancestor, Collection<LinkedObject> lookedAt) {
        if (lookedAt.contains(child)) {
            return false;
        }
        lookedAt.add(child);
        for (Link tr : linkDatabase.getParents(child)) {
            if (tr.getParent().equals(ancestor)) {
                return true;
            }
            if (!TermUtil.hasAncestor(linkDatabase, tr.getParent(), ancestor, lookedAt)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIsAAncestor(LinkedObject child, LinkedObject ancestor) {
        boolean out = TermUtil.hasIsAAncestor(new DefaultLinkDatabase(null), child, ancestor, new HashSet<LinkedObject>());
        return out;
    }

    protected static boolean hasIsAAncestor(LinkDatabase linkDatabase, LinkedObject child, LinkedObject ancestor, Collection<LinkedObject> lookedAt) {
        if (lookedAt.contains(child)) {
            return false;
        }
        lookedAt.add(child);
        for (Link tr : linkDatabase.getParents(child)) {
            if (!tr.getType().equals(OBOProperty.IS_A)) continue;
            if (tr.getParent().equals(ancestor)) {
                return true;
            }
            if (!TermUtil.hasIsAAncestor(linkDatabase, tr.getParent(), ancestor, lookedAt)) continue;
            return true;
        }
        return false;
    }

    public static Link getLink(LinkDatabase linkDatabase, Link link) {
        for (Link l : linkDatabase.getParents(link.getChild())) {
            if (!l.equals(link)) continue;
            return l;
        }
        return null;
    }

    public static boolean containsLink(LinkDatabase linkDatabase, Link link) {
        Collection<Link> parents = linkDatabase.getParents(link.getChild());
        return parents != null && parents.contains(link);
    }

    public static boolean isClass(IdentifiedObject io) {
        if (io.getType() == null) {
            return false;
        }
        return io.getType().equals(OBOClass.OBO_CLASS);
    }

    public static OBOClass getClass(IdentifiedObject io) {
        if (io instanceof OBOClass) {
            return (OBOClass)io;
        }
        return null;
    }

    public static Instance getInstance(IdentifiedObject io) {
        if (io instanceof Instance) {
            return (Instance)io;
        }
        return null;
    }

    public static OBOProperty getProperty(IdentifiedObject io) {
        if (io instanceof OBOProperty) {
            return (OBOProperty)io;
        }
        return null;
    }

    public static boolean isCycle(LinkDatabase linkDatabase, OBOProperty property2, LinkedObject lo) {
        if (linkDatabase instanceof ReasonedLinkDatabase) {
            LinkedList<OBOProperty> properties = new LinkedList<OBOProperty>();
            if (property2 != null) {
                properties.add(property2);
            } else {
                for (IdentifiedObject o : linkDatabase.getObjects()) {
                    if (!(o instanceof OBOProperty)) continue;
                    properties.add((OBOProperty)o);
                }
            }
            for (OBOProperty property2 : properties) {
                if (((ReasonedLinkDatabase)linkDatabase).hasRelationship(lo, property2, lo) == null) continue;
                return true;
            }
            return false;
        }
        return TermUtil.isCycle(linkDatabase, property2, lo, lo, true, new HashSet<LinkedObject>());
    }

    protected static boolean isCycle(LinkDatabase linkDatabase, OBOProperty property, LinkedObject findme, LinkedObject current, boolean skipIt, Set<LinkedObject> seenem) {
        if (!skipIt && findme.equals(current)) {
            return true;
        }
        if (seenem.contains(current)) {
            return false;
        }
        seenem.add(current);
        for (Link link : linkDatabase.getParents(current)) {
            boolean isCycle;
            if (property != null && !ReasonerUtil.isSubclass(linkDatabase, link.getType(), property) || !(isCycle = TermUtil.isCycle(linkDatabase, property, findme, link.getParent(), false, seenem))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDangling(IdentifiedObject io) {
        return io instanceof DanglingObject;
    }

    public static boolean isDescendant(LinkedObject parent, LinkedObject desc) {
        return TermUtil.getDescendants(parent).contains(desc);
    }

    public static boolean isImplied(IdentifiedObject io) {
        logger.debug((Object)"TermUtil.isImplied");
        if (io instanceof Impliable) {
            return ((Impliable)((Object)io)).isImplied();
        }
        return false;
    }

    public static boolean isImplied(PathCapable link) {
        if (link instanceof Impliable) {
            return ((Impliable)((Object)link)).isImplied();
        }
        return false;
    }

    public static boolean isInstance(IdentifiedObject io) {
        return io instanceof Instance;
    }

    public static boolean isIntersection(Link link) {
        if (link instanceof OBORestriction) {
            return ((OBORestriction)link).completes();
        }
        return false;
    }

    public static boolean isIntersection(LinkedObject lo) {
        for (Link link : lo.getParents()) {
            if (!TermUtil.isIntersection(link)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnion(Link link) {
        if (link instanceof OBORestriction) {
            return link.getType().equals(OBOProperty.UNION_OF);
        }
        return false;
    }

    public static boolean isUnion(LinkedObject lo) {
        for (Link link : lo.getParents()) {
            if (!TermUtil.isUnion(link)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegalRelationship(LinkedObject child, OBOProperty type, LinkedObject parent) {
        if (!(!ReasonerUtil.isSubclass(type, OBOProperty.INVERSE_OF) || TermUtil.isProperty(child) && TermUtil.isProperty(parent))) {
            return false;
        }
        return !ReasonerUtil.isSubclass(type, OBOProperty.DISJOINT_FROM) || !TermUtil.isProperty(child) && !TermUtil.isProperty(parent);
    }

    public static boolean isObsolete(IdentifiableObject o) {
        return o instanceof ObsoletableObject && ((ObsoletableObject)o).isObsolete();
    }

    public static boolean isProperty(IdentifiedObject io) {
        if (io.getType() == null) {
            return false;
        }
        return io.getType().equals(OBOClass.OBO_PROPERTY);
    }

    public static boolean isUsed(OBOSession session, OBOProperty prop) {
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : lo.getParents()) {
                if (link.getParent().isBuiltIn() || !link.getType().equals(prop)) continue;
                return true;
            }
        }
        return false;
    }

    public static Link resolve(OBOSession session, Link link) {
        if (link.getParent() instanceof DanglingObject || link.getChild() instanceof DanglingObject || link instanceof DanglingLinkImpl) {
            Link out;
            LinkedObject parent = TermUtil.resolve(session, link.getParent());
            LinkedObject child = TermUtil.resolve(session, link.getChild());
            if (link instanceof DanglingLinkImpl && !TermUtil.isDangling(parent) && !TermUtil.isDangling(child)) {
                out = new OBORestrictionImpl();
                out.setType(link.getType());
            } else {
                out = (Link)link.clone();
            }
            out.setParent(parent);
            out.setChild(child);
            return out;
        }
        return link;
    }

    public static LinkedObject resolve(OBOSession session, LinkedObject pc) {
        if (pc instanceof DanglingObject) {
            IdentifiedObject newObject = session.getObject(pc.getID());
            if (newObject == null || !(newObject instanceof LinkedObject)) {
                return pc;
            }
            return (LinkedObject)newObject;
        }
        return pc;
    }

    public static PathCapable resolve(OBOSession session, PathCapable pc) {
        if (pc instanceof Link) {
            return TermUtil.resolve(session, (Link)pc);
        }
        if (pc instanceof LinkedObject) {
            return TermUtil.resolve(session, (LinkedObject)pc);
        }
        return null;
    }

    public static boolean usesType(LinkedObject lo, OBOProperty prop) {
        for (Link l : lo.getParents()) {
            if (!l.getType().equals(prop)) continue;
            return true;
        }
        return false;
    }

    public static String getScopeLabel(int scope) {
        if (scope == -1 || scope == 0) {
            return "RELATED";
        }
        if (scope == 1) {
            return "EXACT";
        }
        if (scope == 3) {
            return "BROAD";
        }
        if (scope == 2) {
            return "NARROW";
        }
        return null;
    }

    public static int getScopeEnum(String label) {
        if (label == null) {
            return 0;
        }
        String code = (String)label.toLowerCase().subSequence(0, 1);
        if (code.equals("e")) {
            return 1;
        }
        if (code.equals("b")) {
            return 3;
        }
        if (code.equals("n")) {
            return 2;
        }
        return 0;
    }

    public static OBOClass castToClass(LinkedObject lo) {
        if (lo instanceof OBOClass) {
            return (OBOClass)lo;
        }
        if (TermUtil.isDangling(lo)) {
            return new DanglingClassImpl(lo.getID());
        }
        return null;
    }

    public static Instance castToInstance(LinkedObject lo) {
        if (lo instanceof Instance) {
            return (Instance)lo;
        }
        if (TermUtil.isDangling(lo)) {
            return new DanglingInstanceImpl(lo.getID(), null);
        }
        return null;
    }

    public static OBOProperty castToProperty(IdentifiedObject lo) {
        if (lo instanceof OBOProperty) {
            return (OBOProperty)lo;
        }
        if (TermUtil.isDangling(lo)) {
            return new DanglingPropertyImpl(lo.getID());
        }
        return null;
    }

    public static Link castParentToClass(Link link) {
        if (link.getParent() instanceof OBOClass) {
            return link;
        }
        if (TermUtil.isDangling(link.getParent())) {
            OBORestrictionImpl out = new OBORestrictionImpl(link);
            out.setParent(new DanglingClassImpl(link.getParent().getID()));
            return out;
        }
        return null;
    }

    public static boolean isDangling(Link link) {
        return TermUtil.isDangling(link.getParent()) || TermUtil.isDangling(link.getType());
    }

    public static boolean hasDanglingIntersections(LinkedObject lo) {
        for (Link link : lo.getParents()) {
            if (!TermUtil.isIntersection(link) || !TermUtil.isDangling(link)) continue;
            return true;
        }
        return false;
    }

    public static boolean resolveDanglingLink(OBOSession session, Link link) {
        if (TermUtil.isDangling(link)) {
            OBOProperty t;
            boolean resolved = true;
            LinkedObject p = link.getParent();
            if (TermUtil.isDangling(p)) {
                if ((p = (LinkedObject)session.getObject(p.getID())) == null) {
                    resolved = false;
                } else {
                    link.setParent(p);
                    p.addChild(link);
                }
            }
            if (TermUtil.isDangling(t = link.getType())) {
                if ((t = (OBOProperty)session.getObject(t.getID())) == null) {
                    resolved = false;
                } else {
                    link.setType(t);
                }
            }
            return resolved;
        }
        return true;
    }

    public static boolean resolveDanglingLinks(OBOSession session) {
        boolean allResolved = true;
        for (IdentifiedObject io : session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            for (Link link : ((LinkedObject)io).getParents()) {
                boolean resolved = TermUtil.resolveDanglingLink(session, link);
                if (resolved) continue;
                allResolved = true;
            }
        }
        return allResolved;
    }

    public static Iterator<Link> getAllLinks(final LinkDatabase linkDatabase) {
        IteratorFactory<LinkDatabase, IdentifiedObject> objIteratorFactory = new IteratorFactory<LinkDatabase, IdentifiedObject>(){

            public Iterator<IdentifiedObject> getIterator(LinkDatabase object) {
                return object.getObjects().iterator();
            }
        };
        IteratorFactory<IdentifiedObject, Link> linkIteratorFactory = new IteratorFactory<IdentifiedObject, Link>(){

            public Iterator<Link> getIterator(IdentifiedObject object) {
                if (object instanceof LinkedObject) {
                    return linkDatabase.getParents((LinkedObject)object).iterator();
                }
                return EmptyIterator.emptyIterator();
            }
        };
        return new SuperIterator((Object)linkDatabase, new IteratorFactory[]{objIteratorFactory, linkIteratorFactory});
    }

    public static boolean equals(Link a, Link b) {
        return TermUtil.equalsWithoutIntersection(a, b) && TermUtil.isIntersection(a) == TermUtil.isIntersection(b);
    }

    public static boolean equalsWithoutIntersection(Link a, Link b) {
        return ObjectUtil.equals((Object)a.getChild(), (Object)b.getChild()) && ObjectUtil.equals((Object)a.getType(), (Object)b.getType()) && ObjectUtil.equals((Object)a.getParent(), (Object)b.getParent());
    }

    public static TermMacroHistoryItem createGenusDifferentiaHistoryItem(LinkedObject lo, LinkedObject genus, String relID, LinkedObject diffClass) {
        TermMacroHistoryItem item = new TermMacroHistoryItem("Created new xp term");
        String id = lo.getID();
        item.addItem(new CreateLinkHistoryItem(id, relID, diffClass.getID()));
        item.addItem(new CreateLinkHistoryItem(id, "OBO_REL:is_a", genus.getID()));
        item.addItem(new CompletesHistoryItem(id, relID, diffClass.getID(), false));
        item.addItem(new CompletesHistoryItem(id, "OBO_REL:is_a", genus.getID(), false));
        for (Link link : lo.getParents()) {
            if (link.getType().equals(OBOProperty.IS_A) && link.getParent().equals(genus)) {
                item.addItem(new CreateLinkHistoryItem(id, "OBO_REL:is_a", genus.getID()));
            }
            if (!link.getType().getID().equals(relID) || !link.getParent().equals(diffClass)) continue;
            item.addItem(new CreateLinkHistoryItem(id, relID, diffClass.getID()));
        }
        return item;
    }

    public static Collection<String> getLabels(IdentifiedObject lo) {
        LinkedList<String> labels = new LinkedList<String>();
        if (lo.getName() != null) {
            labels.add(lo.getName());
        }
        if (lo instanceof SynonymedObject) {
            for (Synonym syn : ((SynonymedObject)lo).getSynonyms()) {
                labels.add(syn.toString());
            }
        }
        return labels;
    }

    public static Collection<String> getExactLabels(IdentifiedObject lo) {
        LinkedList<String> labels = new LinkedList<String>();
        if (lo.getName() != null) {
            labels.add(lo.getName());
        }
        if (lo instanceof SynonymedObject) {
            for (Synonym syn : ((SynonymedObject)lo).getSynonyms()) {
                if (syn.getScope() != 1) continue;
                labels.add(syn.toString());
            }
        }
        return labels;
    }

    public static Collection<OBOObject> getOBOObjects(OBOSession session) {
        HashSet<OBOObject> objs = new HashSet<OBOObject>();
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof OBOObject)) continue;
            objs.add((OBOObject)io);
        }
        return objs;
    }

    public static Collection<OBOProperty> getProperties(OBOSession session) {
        HashSet<OBOProperty> props = new HashSet<OBOProperty>();
        if (session.getObjects() == null) {
            return null;
        }
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof OBOProperty)) continue;
            props.add((OBOProperty)io);
        }
        return props;
    }

    public static Collection<OBOObject> getSubclasses(OBOObject obj) {
        HashSet<OBOObject> subclasses = new HashSet<OBOObject>();
        for (Link link : obj.getChildren()) {
            if (!link.getType().equals(OBOProperty.IS_A)) continue;
            subclasses.add((OBOObject)link.getChild());
        }
        return subclasses;
    }

    public static TermMacroHistoryItem makeAllSubclassesMutuallyDisjointHistoryItem(OBOObject obj) {
        Collection<OBOObject> subclasses = TermUtil.getSubclasses(obj);
        TermMacroHistoryItem item = new TermMacroHistoryItem("Created new disjoint set");
        for (OBOObject c1 : subclasses) {
            for (OBOObject c2 : subclasses) {
                if (c1.equals(c2)) continue;
                item.addItem(new CreateLinkHistoryItem(c1, OBOProperty.DISJOINT_FROM, c2));
            }
        }
        return item;
    }

    public static String getNameSafe(LinkedObject lo) {
        String name = lo.getName();
        if (name != null) {
            return name;
        }
        return lo.getID();
    }

    public static Collection<OBOProperty> getSuperProperties(OBOProperty prop) {
        HashSet<OBOProperty> props = new HashSet<OBOProperty>();
        for (Link link : prop.getParents()) {
            if (!link.getType().equals(OBOProperty.IS_A)) continue;
            props.add((OBOProperty)link.getParent());
        }
        return props;
    }

    public static Collection<OBOProperty> getSubProperties(OBOProperty prop) {
        HashSet<OBOProperty> props = new HashSet<OBOProperty>();
        for (Link link : prop.getChildren()) {
            if (!link.getType().equals(OBOProperty.IS_A)) continue;
            props.add((OBOProperty)link.getParent());
        }
        return props;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescendantTask
    extends AbstractTaskDelegate<Collection<LinkedObject>> {
        protected Map<LinkedObject, Collection<LinkedObject>> memoizeTable;
        protected LinkedObject term;
        protected LinkDatabase linkDatabase;

        public DescendantTask(LinkDatabase linkDatabase, LinkedObject term, Map<LinkedObject, Collection<LinkedObject>> memoizeTable) {
            this.linkDatabase = linkDatabase;
            this.term = term;
            this.memoizeTable = memoizeTable;
        }

        public void execute() {
            this.setProgressString("Finding descendants");
            if (this.memoizeTable == null) {
                this.memoizeTable = new MultiHashMap();
            }
            this.progress = 0;
            this.setResults(this.getDescendants(100.0, this.linkDatabase, this.term, this.memoizeTable));
        }

        protected Collection<LinkedObject> getDescendants(double incSize, LinkDatabase linkDatabase, LinkedObject term, Map<LinkedObject, Collection<LinkedObject>> memoizeTable) {
            if (linkDatabase == null) {
                linkDatabase = DefaultLinkDatabase.getDefault();
            }
            Collection<LinkedObject> out = memoizeTable.get(term);
            if (memoizeTable.containsKey(term)) {
                this.progress = this.progress + (int)incSize;
                return out;
            }
            out = new HashSet<LinkedObject>();
            memoizeTable.put(term, out);
            for (Link tr : linkDatabase.getChildren(term)) {
                out.add(tr.getChild());
            }
            for (Link tr : linkDatabase.getChildren(term)) {
                out.addAll(this.getDescendants(incSize / (double)term.getChildren().size(), linkDatabase, tr.getChild(), memoizeTable));
            }
            if (term.getChildren().size() == 0) {
                this.progress = this.progress + (int)incSize;
            }
            return out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AncestorTask
    extends AbstractTaskDelegate<Collection<LinkedObject>> {
        protected Map<LinkedObject, Collection<LinkedObject>> memoizeTable;
        protected LinkedObject term;
        protected LinkDatabase linkDatabase;
        protected LinkFilter linkFilter;

        public AncestorTask(LinkDatabase linkDatabase, LinkedObject term, Map<LinkedObject, Collection<LinkedObject>> memoizeTable) {
            this.linkDatabase = linkDatabase;
            this.term = term;
            this.memoizeTable = memoizeTable;
        }

        public void execute() {
            this.setProgressString("Finding ancestors");
            if (this.memoizeTable == null) {
                this.memoizeTable = new MultiHashMap();
            }
            this.progress = 0;
            this.setResults(this.getAncestors(100.0, this.linkDatabase, this.term, this.memoizeTable));
        }

        public LinkFilter getLinkFilter() {
            return this.linkFilter;
        }

        public void setLinkFilter(LinkFilter linkFilter) {
            this.linkFilter = linkFilter;
        }

        protected Collection<LinkedObject> getAncestors(double incSize, LinkDatabase linkDatabase, LinkedObject term, Map<LinkedObject, Collection<LinkedObject>> memoizeTable) {
            logger.debug((Object)"TermUtil.getAncestors");
            if (linkDatabase == null) {
                linkDatabase = DefaultLinkDatabase.getDefault();
            }
            Collection<LinkedObject> out = memoizeTable.get(term);
            if (memoizeTable.containsKey(term)) {
                this.progress = this.progress + (int)incSize;
                return out;
            }
            out = new HashSet<LinkedObject>();
            memoizeTable.put(term, out);
            for (Link tr : linkDatabase.getParents(term)) {
                if (this.linkFilter != null && !this.linkFilter.satisfies(tr)) continue;
                out.add(tr.getParent());
                out.addAll(this.getAncestors(incSize / (double)term.getParents().size(), linkDatabase, tr.getParent(), memoizeTable));
            }
            if (term.getParents().size() == 0) {
                this.progress = this.progress + (int)incSize;
            }
            return out;
        }
    }
}

