/*
 * Decompiled with CFR 0.152.
 */
package org.obo.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.filters.EqualsComparison;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterFactory;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSearchWrapper {
    protected static final Logger logger = Logger.getLogger(DatabaseSearchWrapper.class);
    protected SearchableDatabase searchableDatabase;
    protected SearchResultFormat resultFormat;
    protected OBOSession session;

    public DatabaseSearchWrapper() {
    }

    public DatabaseSearchWrapper(OBOSession session) {
        this.session = session;
    }

    public SearchableDatabase getSearchableDatabase() {
        return this.searchableDatabase;
    }

    public void setSearchableDatabase(SearchableDatabase database) {
        this.searchableDatabase = database;
    }

    public SearchResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(SearchResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public OBOSession getSession() {
        return this.session;
    }

    public void setSession(OBOSession session) {
        this.session = session;
    }

    public String expandToSearchURL(String term) {
        Set<String> terms = this.expandSearchTerm(term);
        String expandedTerm = this.createDisjunctiveQueryString(terms);
        return this.createSearchURL(expandedTerm);
    }

    public String expandToSearchURL(IdentifiedObject obj) {
        Set<String> terms = this.expandSearchTerm(obj);
        String expandedTerm = this.createDisjunctiveQueryString(terms);
        String urlStr = this.createSearchURL(expandedTerm);
        return urlStr;
    }

    public String createSearchURL(String searchTerm) {
        String url = null;
        if (this.searchableDatabase.equals((Object)SearchableDatabase.CLINICAL_TRIALS_GOV)) {
            url = "http://clinicaltrials.gov/ct2/results?term=" + searchTerm;
        }
        return url;
    }

    public Set<String> expandSearchTerm(String label) {
        ObjectFilterFactory off = new ObjectFilterFactory();
        ObjectFilter filter = (ObjectFilter)off.createNewFilter();
        EqualsComparison comparison = new EqualsComparison();
        filter.setComparison(comparison);
        filter.setValue(label);
        LinkedList<IdentifiedObject> objs = new LinkedList<IdentifiedObject>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!filter.satisfies(io)) continue;
            objs.add(io);
        }
        return this.expandSearchTerm(objs);
    }

    public Set<String> expandSearchTerm(Collection<IdentifiedObject> objs) {
        HashSet<String> terms = new HashSet<String>();
        this.expandSearchTerm(objs, terms, 0);
        return this.mostGeneral(terms);
    }

    public Set<String> expandSearchTerm(IdentifiedObject obj) {
        return this.expandSearchTerm(Collections.singleton(obj));
    }

    private void expandSearchTerm(Collection<IdentifiedObject> objs, Set<String> terms, int depth) {
        if (objs.size() == 0) {
            return;
        }
        LinkedList<IdentifiedObject> nextObjs = new LinkedList<IdentifiedObject>();
        for (IdentifiedObject io : objs) {
            if (!(io instanceof LinkedObject)) continue;
            Collection<String> labels = TermUtil.getLabels(io);
            terms.addAll(labels);
            for (Link link : ((LinkedObject)io).getChildren()) {
                if (!link.getType().equals(OBOProperty.IS_A)) continue;
                nextObjs.add(link.getChild());
            }
        }
        this.expandSearchTerm(nextObjs, terms, depth + 1);
    }

    private String createDisjunctiveQueryString(Collection<String> terms) {
        StringBuffer sb = new StringBuffer();
        if (this.searchableDatabase.equals((Object)SearchableDatabase.NCBI)) {
            sb.append("(");
        }
        int i = 0;
        for (String term : terms) {
            if (i > 0) {
                sb.append("+OR+");
            }
            try {
                term = URLEncoder.encode(term, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            sb.append("\"" + term + "\"");
            if (this.searchableDatabase.equals((Object)SearchableDatabase.NCBI)) {
                sb.append("[All Fields]");
            } else if (this.searchableDatabase.equals((Object)SearchableDatabase.CLINICAL_TRIALS_GOV)) {
                sb.append("[ALL-FIELDS]");
            }
            ++i;
        }
        if (this.searchableDatabase.equals((Object)SearchableDatabase.NCBI)) {
            sb.append(")");
        }
        return sb.toString();
    }

    private Set<String> mostGeneral(Set<String> terms) {
        HashSet<String> gterms = new HashSet<String>();
        for (String s1 : terms) {
            boolean isGeneral = true;
            for (String s2 : terms) {
                if (s1.equals(s2) || !s1.contains(s2)) continue;
                isGeneral = false;
                break;
            }
            if (!isGeneral) continue;
            gterms.add(s1);
        }
        return gterms;
    }

    public static void main(String[] args) {
        SearchableDatabase qs = SearchableDatabase.NCBI;
        LinkedList<String> terms = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-resultFormat")) {
                String resultFormat;
                if ((resultFormat = args[++i]).contains("trial")) {
                    qs = SearchableDatabase.CLINICAL_TRIALS_GOV;
                    continue;
                }
                if (resultFormat.contains("google")) {
                    qs = SearchableDatabase.GOOGLE;
                    continue;
                }
                qs = SearchableDatabase.NCBI;
                continue;
            }
            terms.add(args[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchResultFormat {
        HTML,
        XML;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchableDatabase {
        NCBI,
        GOOGLE,
        CLINICAL_TRIALS_GOV;

    }
}

