/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.psidev.ontology_manager.impl;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntologyManagerContext {
    public static final Log log = LogFactory.getLog(OntologyManagerContext.class);
    private File ontologyDirectory = new File(System.getProperty("java.io.tmpdir") + File.separator + "ontologies");
    private boolean storeOntologiesLocally = false;
    private static ThreadLocal<OntologyManagerContext> instance = new ThreadLocal<OntologyManagerContext>(){

        @Override
        protected OntologyManagerContext initialValue() {
            return new OntologyManagerContext();
        }
    };

    public static OntologyManagerContext getInstance() {
        return instance.get();
    }

    private OntologyManagerContext() {
        this.ontologyDirectory.deleteOnExit();
        log.info((Object)("(default) ontology working directory: " + this.ontologyDirectory.getAbsolutePath()));
    }

    public boolean isStoreOntologiesLocally() {
        return this.storeOntologiesLocally;
    }

    public void setStoreOntologiesLocally(boolean storeOntologiesLocally) {
        this.storeOntologiesLocally = storeOntologiesLocally;
    }

    public File getOntologyDirectory() {
        return this.ontologyDirectory;
    }

    public void setOntologyDirectory(File ontologyDirectory) {
        if (ontologyDirectory == null) {
            throw new IllegalArgumentException("You must give a non null ontologyDirectory, use setStoreOntologiesLocally(boolean) to disable the long term storing.");
        }
        this.ontologyDirectory = ontologyDirectory;
        log.info((Object)("setOntologyDirectory: reset ontology working directory to: " + this.ontologyDirectory.getAbsolutePath()));
    }
}

