/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.impl;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.validator.api.AbstractAspect;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
@Aspect
public class ExceptionsAspect
extends AbstractAspect {
    @Around(value="execution(void org.biopax.paxtools.io.SimpleIOHandler.createAndBind(*)) && args(model)")
    public void adviseCreateAndBind(ProceedingJoinPoint jp, Model model) {
        SimpleIOHandler reader = (SimpleIOHandler)jp.getTarget();
        this.validator.indirectlyAssociate((Object)reader, (Object)model);
        try {
            jp.proceed();
        }
        catch (Throwable ex) {
            this.reportException(ex, reader, "syntax.error", "SimpleIOHandler.createAndBind interceptor", null);
        }
    }

    @Around(value="execution(* org.biopax.paxtools.io.SimpleIOHandler.processIndividual(*)) && args(model)")
    public String adviseProcessIndividual(ProceedingJoinPoint jp, Model model) {
        String id = null;
        SimpleIOHandler reader = (SimpleIOHandler)jp.getThis();
        try {
            id = (String)jp.proceed();
        }
        catch (Throwable ex) {
            this.reportException(ex, reader, "syntax.error", "SimpleIOHandler.processIndividual interceptor", null);
        }
        return id;
    }

    @Around(value="execution(private void org.biopax.paxtools.io.SimpleIOHandler.bindValue(..)) && args(triple, model)")
    public void adviseBindValue(ProceedingJoinPoint jp, SimpleIOHandler.Triple triple, Model model) {
        SimpleIOHandler reader;
        SimpleIOHandler o = reader = (SimpleIOHandler)jp.getTarget();
        BioPAXElement el = model.getByID(triple.domain);
        if (el != null) {
            o = el;
            PropertyEditor editor = reader.getEditorMap().getEditorForProperty(triple.property, el.getModelInterface());
            if (editor == null) {
                if (triple.property.equals("taxonXref")) {
                    this.report(el, "unknown.property", "SimpleIOHandler.bindValue interceptor", true, new Object[]{triple.property + " - replaced with 'xref'"});
                    triple.property = "xref";
                } else {
                    this.report(el, "unknown.property", "SimpleIOHandler.bindValue interceptor", false, new Object[]{triple.property + " - skipped"});
                }
            }
        }
        try {
            jp.proceed();
        }
        catch (Throwable t) {
            this.reportException(t, o, "syntax.error", "SimpleIOHandler.bindValue interceptor", triple.toString());
        }
    }

    @Around(value="execution(protected void org.biopax.paxtools.controller.PropertyEditor*+.checkRestrictions(..)) && args(value, bean)")
    public void adviseCheckRestrictions(ProceedingJoinPoint jp, Object value, BioPAXElement bean) {
        try {
            jp.proceed();
        }
        catch (Throwable ex) {
            this.reportException(ex, bean, "syntax.error", "PropertyEditor.checkRestrictions interceptor", String.valueOf(value));
        }
    }

    @Around(value="execution(protected void org.biopax.paxtools.controller.PropertyEditor*+.invokeMethod(..)) && args(method, bean, value)")
    public void adviseInvokeMethod(ProceedingJoinPoint jp, Method method, BioPAXElement bean, Object value) {
        try {
            jp.proceed();
        }
        catch (Throwable ex) {
            this.reportException(ex, bean, "syntax.error", "PropertyEditor.invokeMethod interceptor", "method: " + method + ", value: " + value);
        }
    }

    @Around(value="execution(* org.biopax.paxtools.io.BioPAXIOHandler*+.convertFromOWL(*))")
    public Object adviseConvertFromOwl(ProceedingJoinPoint jp) {
        Object model = null;
        try {
            model = jp.proceed();
        }
        catch (Throwable ex) {
            this.reportException(ex, jp.getTarget(), "syntax.error", "BioPAXIOHandler.convertFromOWL interceptor", null);
        }
        return model;
    }

    @Before(value="execution(* org.biopax.paxtools.io.SimpleIOHandler.skip(..))")
    public void adviseUnknownClass(JoinPoint jp) {
        SimpleIOHandler reader = (SimpleIOHandler)jp.getTarget();
        String loc = reader.getXmlStreamInfo();
        this.report(reader, "unknown.class", "SimpleIOHandler.skip interceptor", false, new Object[]{loc});
    }
}

