/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.validator.api.Rule;
import org.biopax.validator.api.Validator;
import org.biopax.validator.api.ValidatorException;
import org.biopax.validator.api.ValidatorUtils;
import org.biopax.validator.api.beans.Behavior;
import org.biopax.validator.api.beans.ErrorType;
import org.biopax.validator.api.beans.Validation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidatorImpl
implements Validator {
    private static final Log log = LogFactory.getLog(ValidatorImpl.class);
    @Autowired
    private Set<Rule<?>> rules;
    private final Set<Validation> results = Collections.newSetFromMap(new ConcurrentHashMap());
    @Autowired
    private ValidatorUtils utils;

    public void setRules(Set<Rule<?>> rules) {
        this.rules = rules;
    }

    public Set<Rule<?>> getRules() {
        return this.rules;
    }

    public Collection<Validation> getResults() {
        return this.results;
    }

    public void validate(Validation validation) {
        assert (validation != null);
        if (validation == null || validation.getModel() == null) {
            throw new ValidatorException("Failed: no BioPAX model to validate (have you successfully imported or created one already?)", new Object[0]);
        }
        if (!this.getResults().contains(validation)) {
            this.getResults().add(validation);
        }
        if (validation.isMaxErrorsSet() && validation.getNotFixedErrors() > validation.getMaxErrors()) {
            log.info((Object)("Errors limit (" + validation.getMaxErrors() + ") is exceeded; exitting..."));
            return;
        }
        Model model = (Model)validation.getModel();
        log.debug((Object)("validating model: " + model + " that has " + model.getObjects().size() + " objects"));
        if (model.getLevel() != BioPAXLevel.L3) {
            model = new LevelUpgrader().filter(model);
            validation.setModel((Object)model);
            log.info((Object)("Upgraded to BioPAX Level3 model: " + validation.getDescription()));
        }
        assert (model != null && model.getLevel() == BioPAXLevel.L3);
        ExecutorService exec = Executors.newFixedThreadPool(100);
        for (BioPAXElement bioPAXElement : model.getObjects()) {
            this.execute(exec, this.rules, validation, (Object)bioPAXElement);
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ValidatorException("Interrupted unexpectedly!", new Object[0]);
        }
        exec = Executors.newFixedThreadPool(50);
        for (Rule rule : this.rules) {
            Behavior behavior = this.utils.getRuleBehavior(rule.getClass().getName(), validation.getProfile());
            if (behavior == Behavior.IGNORE) continue;
            this.execute(exec, rule, validation, (Object)model);
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ValidatorException("Interrupted unexpectedly!", new Object[0]);
        }
        log.debug((Object)"All rules checked!");
        if (validation.isFix()) {
            model.repair();
            ModelUtils.removeObjectsIfDangling((Model)model, UtilityClass.class);
        }
        validation.addComment("number of interactions : " + model.getObjects(Interaction.class).size());
        validation.addComment("number of physical entities : " + model.getObjects(PhysicalEntity.class).size());
        validation.addComment("number of genes : " + model.getObjects(Gene.class).size());
        validation.addComment("number of pathways : " + model.getObjects(Pathway.class).size());
        for (ErrorType errorType : validation.getError()) {
            errorType.setTotalCases(errorType.countErrors(null, null, false));
            errorType.setNotFixedCases(errorType.countErrors(null, null, true));
        }
        validation.setNotFixedProblems(validation.countErrors(null, null, null, null, false, true));
        validation.setNotFixedErrors(validation.countErrors(null, null, null, null, true, true));
        validation.setTotalProblemsFound(validation.countErrors(null, null, null, null, false, false));
        validation.setSummary("different types of problem: " + validation.getError().size());
    }

    private void execute(ExecutorService exec, final Rule rule, final Validation validation, final Object obj) {
        exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (rule.canCheck(obj)) {
                        rule.check(validation, obj);
                    }
                }
                catch (Throwable t) {
                    String id = validation.identify(obj);
                    log.fatal((Object)(rule + ".check(" + id + ") threw the exception: " + t.toString()), t);
                    validation.addError(ValidatorImpl.this.utils.createError(id, "exception", rule.getClass().getName(), null, false, new Object[]{t}));
                }
            }
        });
    }

    private void execute(ExecutorService exec, final Set<Rule<?>> rules, final Validation validation, final Object obj) {
        exec.execute(new Runnable(){

            @Override
            public void run() {
                for (Rule rule : rules) {
                    Behavior behavior = ValidatorImpl.this.utils.getRuleBehavior(rule.getClass().getName(), validation.getProfile());
                    if (behavior == Behavior.IGNORE) continue;
                    try {
                        if (!rule.canCheck(obj)) continue;
                        rule.check(validation, obj);
                    }
                    catch (Throwable t) {
                        String id = validation.identify(obj);
                        log.fatal((Object)(rule + ".check(" + id + ") threw the exception: " + t.toString()), t);
                        validation.addError(ValidatorImpl.this.utils.createError(id, "exception", rule.getClass().getName(), null, false, new Object[]{t}));
                    }
                }
            }
        });
    }

    public void importModel(Validation validation, InputStream inputStream) {
        SimpleIOHandler simpleReader = new SimpleIOHandler();
        simpleReader.mergeDuplicates(true);
        this.associate(inputStream, validation);
        this.associate(simpleReader, validation);
        Model model = simpleReader.convertFromOWL(inputStream);
        if (model == null) {
            throw new ValidatorException("Failed importing a BioPAX model!", new Object[0]);
        }
        this.associate(model, validation);
    }

    public void associate(Object obj, Validation validation) {
        assert (validation != null);
        if (!this.getResults().contains(validation)) {
            if (validation != null) {
                this.getResults().add(validation);
            } else {
                log.warn((Object)("Object " + obj + " is being associated with NULL (Validation)!"));
            }
        }
        if (obj instanceof Model) {
            validation.setModel((Object)((Model)obj));
        } else {
            validation.getObjects().add(obj);
        }
    }

    public Collection<Validation> findValidation(Object o) {
        HashSet<Validation> keys = new HashSet<Validation>();
        if (o == null || o.getClass().isPrimitive() || o instanceof String) {
            return keys;
        }
        for (Validation r : this.results) {
            if (r.getObjects().contains(o) || o.equals(r.getModel())) {
                keys.add(r);
                continue;
            }
            if (!(o instanceof BioPAXElement)) continue;
            BioPAXElement bpe = (BioPAXElement)o;
            Model m = (Model)r.getModel();
            if (m == null || !m.contains(bpe)) continue;
            keys.add(r);
        }
        if (keys.isEmpty()) {
            log.debug((Object)("findKey: no result keys found for the object : " + o));
        }
        return keys;
    }

    public void indirectlyAssociate(Object parent, Object child) {
        if (parent == null || child == null || child.getClass().isPrimitive() || child instanceof String) {
            return;
        }
        for (Validation key : this.findValidation(parent)) {
            this.associate(child, key);
        }
    }

    public void report(Object obj, String errorCode, String reportedBy, boolean isFixed, Object ... args) {
        if (obj == null) {
            log.error((Object)("Attempted to registed an error " + errorCode + " by " + reportedBy + " with NULL object"));
            return;
        }
        Collection<Validation> validations = this.findValidation(obj);
        if (validations.isEmpty()) {
            log.warn((Object)("No validations are associated with the object: " + obj + "; user won't receive this message: " + errorCode + "(fixed=" + isFixed + ") by " + reportedBy + "; " + args));
        }
        for (Validation v : validations) {
            ErrorType err = this.utils.createError(v.identify(obj), errorCode, reportedBy, v.getProfile(), isFixed, args);
            v.addError(err);
            log.debug((Object)(v.getDescription() + " - added/updated " + err + " for " + obj + " as: " + isFixed));
        }
    }
}

