/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashMap;
import java.util.Set;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Degradation;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class ConversionStoichiometryCheckRule
extends AbstractRule<Conversion> {
    public void check(Validation validation, Conversion thing) {
        float rsto;
        float lsto = this.getStoichiometry(thing.getParticipantStoichiometry(), thing.getLeft());
        float diff = Math.abs(lsto - (rsto = (float)this.getStoichiometry(thing.getParticipantStoichiometry(), thing.getRight())));
        if (diff > 0.0f) {
            this.error(validation, thing, "stoichiometry.mismatch", false, new Object[]{Float.valueOf(lsto), Float.valueOf(rsto)});
        }
    }

    private int getStoichiometry(Set<Stoichiometry> stois, Set<PhysicalEntity> pes) {
        int total = 0;
        HashMap<PhysicalEntity, Float> stoiMap = new HashMap<PhysicalEntity, Float>();
        for (Stoichiometry s : stois) {
            stoiMap.put(s.getPhysicalEntity(), Float.valueOf(s.getStoichiometricCoefficient()));
        }
        for (PhysicalEntity pe : pes) {
            if (pe instanceof Complex) {
                Complex c = (Complex)pe;
                total += this.getStoichiometry(c.getComponentStoichiometry(), c.getComponent());
                continue;
            }
            Float k = (Float)stoiMap.get(pe);
            if (k == null) {
                k = Float.valueOf(1.0f);
            }
            total = (int)((float)total + k.floatValue());
        }
        return total;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Conversion && !(thing instanceof Degradation);
    }
}

