/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class ConversionToComplexAssemblyRule
extends AbstractRule<Conversion> {
    public void check(Validation validation, Conversion thing) {
        Fetcher fetcher = new Fetcher((EditorMap)SimpleEditorMap.L3, new Filter[]{new Filter<PropertyEditor>(){

            public boolean filter(PropertyEditor editor) {
                return editor.getProperty().equals("component");
            }
        }});
        HashSet<PhysicalEntity> left = new HashSet<PhysicalEntity>(this.getPEsRecursively(thing.getLeft(), fetcher));
        Set<PhysicalEntity> right = this.getPEsRecursively(thing.getRight(), fetcher);
        left.removeAll(right);
        int complexDiff = this.getComplexCount(thing.getLeft()) - this.getComplexCount(thing.getRight());
        if (left.isEmpty() && (complexDiff != 0 || thing.getLeft().size() - thing.getRight().size() != 0)) {
            this.error(validation, thing, "wrong.conversion.class", false, new Object[]{thing.getModelInterface()});
        }
    }

    private int getComplexCount(Set<PhysicalEntity> pes) {
        int count = 0;
        for (PhysicalEntity pe : pes) {
            if (!(pe instanceof Complex)) continue;
            ++count;
        }
        return count;
    }

    private Set<PhysicalEntity> getPEsRecursively(Set<PhysicalEntity> pes, Fetcher fetcher) {
        Model m = BioPAXLevel.L3.getDefaultFactory().createModel();
        for (PhysicalEntity pe : pes) {
            if (pe instanceof Complex) {
                fetcher.fetch((BioPAXElement)pe, m);
                continue;
            }
            if (m.containsID(pe.getRDFId())) continue;
            m.add((BioPAXElement)pe);
        }
        return m.getObjects(PhysicalEntity.class);
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Conversion && !(thing instanceof ComplexAssembly);
    }
}

