/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class DisplayNameRule
extends AbstractRule<Named> {
    public static final int MAX_DISPLAYNAME_LEN = 25;

    public boolean canCheck(Object thing) {
        return thing instanceof Named;
    }

    public void check(Validation validation, Named named) {
        String name;
        boolean fixed = false;
        if (named.getDisplayName() == null) {
            if (validation.isFix()) {
                if (named.getStandardName() != null) {
                    named.setDisplayName(named.getStandardName());
                    fixed = true;
                } else if (!named.getName().isEmpty()) {
                    String dsp = (String)named.getName().iterator().next();
                    for (String name2 : named.getName()) {
                        if (name2.length() >= dsp.length()) continue;
                        dsp = name2;
                    }
                    named.setDisplayName(dsp);
                    fixed = true;
                }
            }
            this.error(validation, named, "no.display.name", fixed && validation.isFix(), new Object[0]);
        }
        if ((name = named.getDisplayName()) != null) {
            Integer max = named instanceof Provenance ? 50 : 25;
            if (name.length() > max) {
                this.error(validation, named, "too.long.display.name", false, new Object[]{name + (fixed ? "(auto-created form other names!)" : ""), name.length(), max});
            }
        }
    }
}

