/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class DuplicateIdCaseInsensitiveRule
extends AbstractRule<Model> {
    public void check(Validation validation, Model model) {
        Cluster<BioPAXElement> algorithm = new Cluster<BioPAXElement>(){

            @Override
            public boolean match(BioPAXElement a, BioPAXElement b) {
                return !a.equals(b) && a.getRDFId().equalsIgnoreCase(b.getRDFId());
            }
        };
        Set clasters = algorithm.cluster(model.getObjects(), Integer.MAX_VALUE);
        for (Set duplicates : clasters) {
            if (duplicates.size() <= 1) continue;
            BioPAXElement u = (BioPAXElement)duplicates.iterator().next();
            duplicates.remove(u);
            this.error(validation, u, "duplicate.id.ignoringcase", false, new Object[]{duplicates, u.getModelInterface().getSimpleName()});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model;
    }
}

