/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class EntityReferenceSamePhysicalEntitiesRule
extends AbstractRule<EntityReference> {
    Cluster<SimplePhysicalEntity> algorithm = new Cluster<SimplePhysicalEntity>(){

        @Override
        public boolean match(SimplePhysicalEntity e1, SimplePhysicalEntity e2) {
            return e1.hasEquivalentFeatures((PhysicalEntity)e2) && e1.hasEquivalentCellularLocation((PhysicalEntity)e2);
        }
    };

    public void check(Validation validation, EntityReference eref) {
        Set<Set<SimplePhysicalEntity>> clasters = this.algorithm.cluster(eref.getEntityReferenceOf(), Integer.MAX_VALUE);
        for (Set<SimplePhysicalEntity> col : clasters) {
            if (col.size() <= 1) continue;
            SimplePhysicalEntity u = col.iterator().next();
            col.remove(u);
            this.error(validation, eref, "same.state.entity", false, new Object[]{u, col});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof EntityReference;
    }
}

