/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class GenericEntityReferenceXrefRule
extends AbstractRule<EntityReference> {
    public void check(Validation validation, EntityReference er) {
        if (!er.getMemberEntityReference().isEmpty()) {
            if (er.getXref().isEmpty()) {
                this.error(validation, er, "no.xrefs", false, new Object[0]);
            } else {
                boolean present = false;
                for (Xref x : er.getXref()) {
                    Class face = x.getModelInterface();
                    if (!UnificationXref.class.equals((Object)face)) continue;
                    present = true;
                }
                if (!present) {
                    this.error(validation, er, "no.unification.xref", false, new Object[0]);
                }
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof EntityReference;
    }
}

