/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.Transport;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class InteractionParticipantsLocationRule
extends AbstractRule<Interaction> {
    public void check(Validation validation, Interaction thing) {
        if (thing instanceof TemplateReaction) {
            return;
        }
        Set ents = thing.getParticipant();
        if (ents != null) {
            for (Entity e1 : ents) {
                if (!(e1 instanceof PhysicalEntity)) continue;
                for (Entity e2 : ents) {
                    if (!(e2 instanceof PhysicalEntity) || e1.equals(e2) || ((PhysicalEntity)e1).hasEquivalentCellularLocation((PhysicalEntity)e2)) continue;
                    if (thing instanceof Transport) {
                        boolean onDifferentSides;
                        Transport tr = (Transport)thing;
                        boolean bl = onDifferentSides = tr.getLeft().contains(e1) && !tr.getLeft().contains(e2) || !tr.getLeft().contains(e1) && tr.getLeft().contains(e2);
                        if (onDifferentSides) continue;
                    }
                    this.error(validation, thing, "multiple.location", false, new Object[]{e1, e2});
                }
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Interaction && !(thing instanceof TemplateReaction);
    }
}

