/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class SameLeftRightRule
extends AbstractRule<Conversion> {
    public void check(Validation validation, Conversion conversion2) {
        Set left = conversion2.getLeft();
        Set right = conversion2.getRight();
        for (PhysicalEntity lefty : left) {
            for (PhysicalEntity righty : right) {
                boolean isSame = false;
                isSame = righty.isEquivalent((BioPAXElement)lefty) && lefty.isEquivalent((BioPAXElement)righty);
                if (!isSame) continue;
                if (lefty instanceof SimplePhysicalEntity) {
                    assert (righty instanceof SimplePhysicalEntity);
                    EntityReference ler = ((SimplePhysicalEntity)lefty).getEntityReference();
                    EntityReference rer = ((SimplePhysicalEntity)righty).getEntityReference();
                    if (ler != null && rer != null && !ler.getRDFId().equalsIgnoreCase(rer.getRDFId())) {
                        isSame = false;
                    }
                }
                if (!isSame) continue;
                this.error(validation, conversion2, "same.state.participant", false, new Object[]{lefty, righty});
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Conversion;
    }
}

