/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.ExperimentalFormVocabulary;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.InteractionVocabulary;
import org.biopax.paxtools.model.level3.PhenotypeVocabulary;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnificationXrefLimitedRule
extends AbstractRule<UnificationXref> {
    private static final Map<Class<? extends BioPAXElement>, Set<String>> allow = new ConcurrentHashMap<Class<? extends BioPAXElement>, Set<String>>();
    private static final Map<Class<? extends BioPAXElement>, Set<String>> deny = new ConcurrentHashMap<Class<? extends BioPAXElement>, Set<String>>();
    private XrefHelper helper;
    private boolean ready = false;

    void initInternalMaps() {
        if (!this.ready) {
            List<String> synonymsOfDb;
            Set<String> a;
            for (Class<? extends BioPAXElement> clazz : allow.keySet()) {
                a = allow.get(clazz);
                for (String db : new HashSet<String>(a)) {
                    synonymsOfDb = this.helper.getSynonymsForDbName(db);
                    a.addAll(synonymsOfDb);
                }
            }
            for (Class<? extends BioPAXElement> clazz : deny.keySet()) {
                a = deny.get(clazz);
                for (String db : new HashSet<String>(a)) {
                    synonymsOfDb = this.helper.getSynonymsForDbName(db);
                    a.addAll(synonymsOfDb);
                }
            }
            this.ready = true;
        }
    }

    @Autowired
    public UnificationXrefLimitedRule(XrefHelper xrefHelper) {
        this.helper = xrefHelper;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof UnificationXref;
    }

    public void check(Validation validation, UnificationXref x) {
        if (!this.ready) {
            this.initInternalMaps();
        }
        if (x.getDb() == null || this.helper.getPrimaryDbName(x.getDb()) == null) {
            return;
        }
        String xdb = this.helper.dbName(x.getDb());
        for (XReferrable bpe : x.getXrefOf()) {
            for (Class<? extends BioPAXElement> c : allow.keySet()) {
                if (!c.isInstance(bpe) || allow.get(c).contains(xdb)) continue;
                this.error(validation, x, "not.allowed.xref", false, new Object[]{x.getDb(), bpe, c.getSimpleName(), allow.get(c).toString()});
            }
            for (Class<? extends BioPAXElement> c : deny.keySet()) {
                if (!c.isInstance(bpe) || !deny.get(c).contains(xdb)) continue;
                this.error(validation, x, "denied.xref", false, new Object[]{x.getDb(), bpe, c.getSimpleName(), deny.get(c).toString()});
            }
        }
    }

    static {
        allow.put(BioSource.class, new HashSet<String>(Arrays.asList("taxonomy")));
        allow.put(Provenance.class, new HashSet<String>(Arrays.asList("miriam")));
        allow.put(CellVocabulary.class, new HashSet<String>(Arrays.asList("cl")));
        allow.put(TissueVocabulary.class, new HashSet<String>(Arrays.asList("bto")));
        allow.put(CellularLocationVocabulary.class, new HashSet<String>(Arrays.asList("go")));
        allow.put(EvidenceCodeVocabulary.class, new HashSet<String>(Arrays.asList("mi")));
        allow.put(ExperimentalFormVocabulary.class, new HashSet<String>(Arrays.asList("mi")));
        allow.put(InteractionVocabulary.class, new HashSet<String>(Arrays.asList("mi")));
        allow.put(SequenceModificationVocabulary.class, new HashSet<String>(Arrays.asList("so", "mod")));
        allow.put(PhenotypeVocabulary.class, new HashSet<String>(Arrays.asList("pato")));
        allow.put(RelationshipTypeVocabulary.class, new HashSet<String>(Arrays.asList("mi")));
        allow.put(SequenceRegionVocabulary.class, new HashSet<String>(Arrays.asList("so")));
        deny.put(Dna.class, new HashSet<String>(Arrays.asList("uniprot", "pubmed")));
        deny.put(Rna.class, new HashSet<String>(Arrays.asList("uniprot")));
        deny.put(DnaReference.class, new HashSet<String>(Arrays.asList("uniprot", "pubmed")));
        deny.put(RnaReference.class, new HashSet<String>(Arrays.asList("uniprot")));
        deny.put(SmallMoleculeReference.class, new HashSet<String>(Arrays.asList("uniprot")));
        deny.put(SmallMolecule.class, new HashSet<String>(Arrays.asList("uniprot")));
        deny.put(PhysicalEntity.class, new HashSet<String>(Arrays.asList("go")));
        deny.put(ProteinReference.class, new HashSet<String>(Arrays.asList("OMIM", "Entrez Gene")));
        deny.put(Interaction.class, new HashSet<String>(Arrays.asList("mi")));
    }
}

