/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XrefRule
extends AbstractRule<Xref> {
    @Autowired
    XrefHelper xrefHelper;

    public boolean canCheck(Object thing) {
        return thing instanceof Xref;
    }

    public void check(Validation validation, Xref x) {
        block6: {
            String newId;
            String id;
            String preferedDbName;
            block11: {
                String newId2;
                int i;
                String regxp;
                block10: {
                    block9: {
                        block8: {
                            String db;
                            block7: {
                                db = x.getDb();
                                if (db == null) break block6;
                                preferedDbName = this.xrefHelper.getPrimaryDbName(db);
                                if (preferedDbName == null) {
                                    this.error(validation, x, "unknown.db", false, new Object[]{db});
                                    return;
                                }
                                assert (preferedDbName.equals(preferedDbName.toUpperCase()));
                                id = x.getId();
                                if (id == null) break block6;
                                if (this.xrefHelper.canCheckIdFormatIn(preferedDbName)) break block7;
                                this.logger.info((Object)("Can't check IDs (no regexp) for " + db + " (" + preferedDbName + ")"));
                                break block6;
                            }
                            if (this.xrefHelper.checkIdFormat(preferedDbName, id)) break block6;
                            regxp = this.xrefHelper.getRegexpString(preferedDbName);
                            this.error(validation, x, "invalid.id.format", false, new Object[]{db, preferedDbName, id, regxp});
                            if (!validation.isFix()) break block6;
                            if (!preferedDbName.startsWith("UNIPROT")) break block8;
                            if (!id.contains("-") || !this.xrefHelper.checkIdFormat("UniProt Isoform", id.toUpperCase())) break block9;
                            x.setDb("UniProt Isoform");
                            x.setId(id.toUpperCase());
                            this.error(validation, x, "invalid.id.format", true, new Object[0]);
                            break block6;
                        }
                        if (!preferedDbName.equalsIgnoreCase("MOLECULAR INTERACTIONS ONTOLOGY") || !id.toUpperCase().startsWith("MOD") || !this.xrefHelper.checkIdFormat("MOD", id.toUpperCase())) break block9;
                        x.setDb("PSI-MOD");
                        x.setId(id.toUpperCase());
                        this.error(validation, x, "invalid.id.format", true, new Object[0]);
                        break block6;
                    }
                    if ((i = id.lastIndexOf(45)) < 0) {
                        i = id.lastIndexOf(95);
                    }
                    if (i < 0) {
                        i = id.lastIndexOf(46);
                    }
                    if (i <= 0 || i >= id.length() || !this.xrefHelper.checkIdFormat(preferedDbName, newId = id.substring(0, i))) break block10;
                    x.setId(newId);
                    x.setIdVersion(id.substring(i + 1));
                    this.error(validation, x, "invalid.id.format", true, new Object[0]);
                    break block6;
                }
                i = regxp.lastIndexOf(58);
                if (i <= 0) break block11;
                String prefix = regxp.substring(1, i).toUpperCase();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Trying to fix id with missing prefix: " + prefix));
                }
                if (!preferedDbName.equalsIgnoreCase(this.xrefHelper.getPrimaryDbName(prefix)) || id.toUpperCase().startsWith(prefix) || !this.xrefHelper.checkIdFormat(preferedDbName, newId2 = prefix + ':' + id)) break block11;
                x.setId(newId2);
                this.error(validation, x, "invalid.id.format", true, new Object[0]);
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)(x.getModelInterface().getSimpleName() + " " + x + " 'id' auto-fixed! (was: " + id + ")"));
                break block6;
            }
            if (!this.xrefHelper.checkIdFormat(preferedDbName, newId = id.toUpperCase())) break block6;
            x.setId(newId);
            this.error(validation, x, "invalid.id.format", true, new Object[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(x.getModelInterface().getSimpleName() + " " + x + " 'id' auto-fixed! (was: " + id + ")"));
            }
        }
    }
}

