/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.psidev.ontology_manager.OntologyAccess;
import org.biopax.psidev.ontology_manager.OntologyTermI;
import org.biopax.psidev.ontology_manager.impl.OntologyManagerImpl;
import org.biopax.validator.api.CvRestriction;
import org.biopax.validator.api.CvRule;
import org.biopax.validator.api.CvValidator;

public class BiopaxOntologyManager
extends OntologyManagerImpl
implements CvValidator {
    private static final Log log = LogFactory.getLog(BiopaxOntologyManager.class);

    public BiopaxOntologyManager(Properties ontologiesConfig) {
        try {
            this.loadOntologies(ontologiesConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load or parse all required biological ontologies!", e);
        }
    }

    public Set<String> getValidTermNames(CvRule<?> cvRule) {
        return this.getValidTermNamesLowerCase(cvRule.getRestrictions());
    }

    public Set<OntologyTermI> getValidTerms(CvRule<?> cvRule) {
        return this.getValidTerms(cvRule.getRestrictions());
    }

    public Set<String> getValidTermNames(Collection<CvRestriction> restrictions) {
        HashSet<String> names = new HashSet<String>();
        Set<OntologyTermI> terms = this.getValidTerms(restrictions);
        names.addAll(BiopaxOntologyManager.getTermNames(terms));
        return names;
    }

    public Set<String> getValidTermNamesLowerCase(Collection<CvRestriction> restrictions) {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.getValidTermNames(restrictions)) {
            names.add(name.toLowerCase());
        }
        return names;
    }

    public Set<String> getTermNames(CvRestriction restriction) {
        Set<OntologyTermI> terms = this.getTerms(restriction);
        HashSet<String> names = new HashSet<String>();
        names.addAll(BiopaxOntologyManager.getTermNames(terms));
        return names;
    }

    public Set<OntologyTermI> getValidTerms(Collection<CvRestriction> restrictions) {
        HashSet<OntologyTermI> terms = new HashSet<OntologyTermI>();
        for (CvRestriction restriction : restrictions) {
            if (restriction.isNot()) continue;
            terms.addAll(this.getTerms(restriction));
        }
        for (CvRestriction restriction : restrictions) {
            if (!restriction.isNot()) continue;
            terms.removeAll(this.getTerms(restriction));
        }
        return terms;
    }

    public Set<OntologyTermI> getTerms(CvRestriction restriction) {
        HashSet<OntologyTermI> terms = new HashSet<OntologyTermI>();
        OntologyAccess ontologyAccess = this.getOntology(restriction.getOntologyId());
        if (ontologyAccess == null) {
            throw new IllegalArgumentException("Cannot get access to the ontology using ID: " + restriction.getOntologyId() + "; I know the following IDs: " + this.getOntologyIDs().toString());
        }
        OntologyTermI term = ontologyAccess.getTermForAccession(restriction.getId());
        if (term == null) {
            log.error((Object)("Cannot Get " + restriction.getOntologyId() + " OntologyAccess Term for the Accession: " + restriction.getId()));
            return terms;
        }
        if (restriction.isTermAllowed()) {
            terms.add(term);
        }
        if (restriction.getChildrenAllowed() == CvRestriction.UseChildTerms.ALL) {
            terms.addAll(ontologyAccess.getAllChildren(term));
        } else if (restriction.getChildrenAllowed() == CvRestriction.UseChildTerms.DIRECT) {
            terms.addAll(ontologyAccess.getDirectChildren(term));
        }
        for (OntologyTermI t : terms) {
            t.setPreferredName(StringEscapeUtils.unescapeXml((String)t.getPreferredName()));
            HashSet<String> synonyms = new HashSet<String>();
            for (String s : t.getNameSynonyms()) {
                synonyms.add(StringEscapeUtils.unescapeXml((String)s));
            }
            t.setNameSynonyms(synonyms);
        }
        return terms;
    }
}

