/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Cluster<T> {
    public abstract boolean match(T var1, T var2);

    public final Set<Set<T>> cluster(Collection<T> elements, int clusterMaxSize) {
        HashSet clusters = new HashSet();
        for (T u : new HashSet<T>(elements)) {
            HashSet<Set> hashSet = new HashSet<Set>();
            for (Set set : clusters) {
                if (set.isEmpty() || !this.matchAny(u, set)) continue;
                set.add(u);
                hashSet.add(set);
            }
            if (hashSet.isEmpty()) {
                HashSet<T> group = new HashSet<T>();
                group.add(u);
                clusters.add(group);
                continue;
            }
            if (hashSet.size() <= 1) continue;
            Iterator it = hashSet.iterator();
            Set set = (Set)it.next();
            assert (!set.isEmpty());
            while (it.hasNext()) {
                Set g = (Set)it.next();
                set.addAll(g);
                g.clear();
            }
        }
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        for (Set set : clusters) {
            if (set.isEmpty()) continue;
            result.add(set);
        }
        return result;
    }

    private boolean matchAny(T u, Set<T> clu) {
        for (T t : clu) {
            if (!this.match(u, t) && !this.match(t, u)) continue;
            return true;
        }
        return false;
    }
}

