/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import org.apache.commons.collections15.collection.CompositeCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.miriam.MiriamLink;
import org.biopax.psidev.ontology_manager.OntologyAccess;
import org.biopax.psidev.ontology_manager.OntologyTermI;
import org.biopax.psidev.ontology_manager.impl.OntologyTermImpl;
import org.biopax.validator.utils.BiopaxOntologyManager;
import org.biopax.validator.utils.Cluster;

public class XrefHelper {
    private static final Log log = LogFactory.getLog(XrefHelper.class);
    private Map<String, Pattern> dataPatterns = new ConcurrentHashMap<String, Pattern>();
    private CompositeCollection<String> allSynonyms;
    private BiopaxOntologyManager ontologyManager;
    private final CompositeCollection<String> extraGroups = new CompositeCollection();
    private Set<String> unofficialDbNames;

    public XrefHelper(Set<List<String>> extraSynonyms, BiopaxOntologyManager ontologyManager) {
        if (extraSynonyms != null) {
            for (List<String> group : extraSynonyms) {
                ArrayList<String> newG = new ArrayList<String>();
                for (String s : group) {
                    newG.add(this.dbName(s));
                }
                this.extraGroups.addComposited(newG);
            }
        }
        this.ontologyManager = ontologyManager;
    }

    @PostConstruct
    synchronized void init() {
        this.allSynonyms = new CompositeCollection();
        this.unofficialDbNames = Collections.newSetFromMap(new ConcurrentHashMap());
        CompositeCollection allSynonyms = new CompositeCollection();
        for (String dt : MiriamLink.getDataTypesName()) {
            String regexp = MiriamLink.getDataTypePattern((String)dt);
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                log.error((Object)("Pattern compilation failed for MIRIAM db=" + dt + "; regexp=" + dt + "; " + e));
            }
            String db = this.dbName(dt);
            ArrayList<String> synonyms = new ArrayList<String>();
            synonyms.add(db);
            String[] names = MiriamLink.getNames((String)dt);
            if (names != null) {
                for (String name : names) {
                    String s = this.dbName(name);
                    if (synonyms.contains(s)) continue;
                    synonyms.add(s);
                }
            }
            allSynonyms.addComposited(synonyms);
            if (pattern == null) continue;
            this.dataPatterns.put(db, pattern);
        }
        OntologyAccess mi = this.ontologyManager.getOntology("MI");
        Set terms = mi.getAllChildren((OntologyTermI)new OntologyTermImpl("MI:0444"));
        for (OntologyTermI term : terms) {
            ArrayList<String> synonyms = new ArrayList<String>();
            synonyms.add(this.dbName(term.getPreferredName()));
            for (String name : term.getNameSynonyms()) {
                String s = this.dbName(name);
                if (synonyms.contains(s)) continue;
                synonyms.add(s);
            }
            allSynonyms.addComposited(synonyms);
        }
        for (String db : this.extraGroups) {
            if (allSynonyms.contains((Object)db)) continue;
            this.unofficialDbNames.add(db);
        }
        allSynonyms.addComposited((Collection[])this.extraGroups.getCollections().toArray());
        Cluster<Collection<String>> clus = new Cluster<Collection<String>>(){

            @Override
            public boolean match(Collection<String> a, Collection<String> b) {
                return !Collections.disjoint(a, b);
            }
        };
        Set groupsOfGroups = clus.cluster(allSynonyms.getCollections(), Integer.MAX_VALUE);
        for (Set groupsToMerge : groupsOfGroups) {
            if (groupsToMerge.size() > 1) {
                ArrayList<String> merged = new ArrayList<String>();
                String primary = null;
                for (Collection group : groupsToMerge) {
                    for (String name : group) {
                        if (this.dataPatterns.containsKey(name)) {
                            primary = name;
                        }
                        if (merged.contains(name)) continue;
                        merged.add(name);
                    }
                }
                if (primary != null) {
                    merged.remove(primary);
                    merged.add(0, primary);
                }
                this.allSynonyms.addComposited(merged);
                continue;
            }
            assert (!groupsToMerge.isEmpty());
            this.allSynonyms.addComposited((Collection)groupsToMerge.iterator().next());
        }
        assert (!this.getSynonymsForDbName("EntrezGene").isEmpty());
        assert (!this.getSynonymsForDbName("chebi").isEmpty());
        assert (this.xcheck());
    }

    private boolean xcheck() {
        Object[] lists = this.allSynonyms.getCollections().toArray();
        for (int i = 0; i < lists.length; ++i) {
            List li = (List)lists[i];
            for (int j = i + 1; j < lists.length; ++j) {
                if (Collections.disjoint(li, (Collection)lists[j])) continue;
                log.error((Object)("different synonyms groups intercection found: " + li.toString() + " has names in common with " + lists[j].toString()));
                return false;
            }
        }
        return true;
    }

    public String dbName(String name) {
        return name.trim().toUpperCase();
    }

    public List<String> getSynonymsForDbName(String name) {
        return this.getSynonymsForName(name, this.allSynonyms);
    }

    private List<String> getSynonymsForName(String name, CompositeCollection<String> groups) {
        String dbName = this.dbName(name);
        for (Collection group : groups.getCollections()) {
            if (!group.contains(dbName)) continue;
            return (List)group;
        }
        return Collections.emptyList();
    }

    public String getPrimaryDbName(String name) {
        String dbName = this.dbName(name);
        for (Collection group : this.allSynonyms.getCollections()) {
            if (!group.contains(dbName)) continue;
            return (String)group.iterator().next();
        }
        return null;
    }

    public boolean checkIdFormat(String db, String id) {
        String name = this.getPrimaryDbName(db);
        Pattern p = this.dataPatterns.get(name);
        return p.matcher(id).find();
    }

    public boolean canCheckIdFormatIn(String name) {
        String db = this.getPrimaryDbName(name);
        return db == null ? false : this.dataPatterns.get(db) != null;
    }

    public String getRegexpString(String db) {
        String name = this.getPrimaryDbName(db);
        Pattern p = this.dataPatterns.get(name);
        return p != null ? p.pattern() : null;
    }

    public boolean isSynonyms(String db1, String db2) {
        return this.getSynonymsForDbName(db1).contains(this.dbName(db2));
    }

    Set<String> getUnofficialDbNames() {
        return this.unofficialDbNames;
    }

    public boolean isUnofficialOrMisspelledDbName(String db) {
        return this.getUnofficialDbNames().contains(this.dbName(db));
    }
}

