/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression;

import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.bbop.expression.FunctionDef;
import org.bbop.expression.FunctionMappingImpl;
import org.bbop.expression.Script;
import org.bbop.expression.ScriptFactory;
import org.bbop.expression.context.HashMapContext;

public class Jexl {
    protected static final Logger logger = Logger.getLogger(Jexl.class);

    public static void main(String[] args) throws Exception {
        HashMapContext context = new HashMapContext();
        Class[] classArgs = new Class[]{Double.TYPE};
        Method m = null;
        try {
            m = Math.class.getMethod("abs", classArgs);
            context.defineGlobalFunction("abs", new FunctionMappingImpl(m));
            Class[] printArgs = new Class[]{String.class};
            m = System.out.getClass().getMethod("print", printArgs);
            context.defineGlobalFunction("print", new FunctionMappingImpl(System.out, m));
            m = System.out.getClass().getMethod("println", printArgs);
            context.defineGlobalFunction("println", new FunctionMappingImpl(System.out, m));
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        context.setGlobalVariable("temp", new Temp(), false);
        try {
            for (int i = 0; i < args.length; ++i) {
                RandomAccessFile f = new RandomAccessFile(args[i], "r");
                byte[] arr = new byte[(int)f.length()];
                f.readFully(arr);
                f.close();
                String s = new String(arr);
                Script e = ScriptFactory.createScript(s);
                logger.info((Object)("Progam finished with return val " + e.execute(context.createNewFrame())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Temp {
        public int myVal = 99;
        private FunctionDef methodDelegate;

        public void setMethodDelegate(FunctionDef methodDelegate) {
            this.methodDelegate = methodDelegate;
        }

        public FunctionDef getMethodDelegate() {
            return this.methodDelegate;
        }

        public int getMyVal() {
            return this.myVal;
        }

        public void setMyVal(int myVal) {
            this.myVal = myVal;
        }
    }
}

