/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.FunctionDef;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.ParseException;

public class HashMapContext
implements JexlContext {
    protected static final Logger logger = Logger.getLogger(HashMapContext.class);
    static final long serialVersionUID = 5715964743204418854L;
    protected Map globalVars;
    protected Map globalFunctions;
    protected Set modifiableGlobals;
    protected Map localVars;
    protected Map localFunctions;
    protected Set modifiableLocals;

    public HashMapContext() {
        this.globalVars = new HashMap();
        this.localVars = new HashMap();
        this.localFunctions = new HashMap();
        this.globalFunctions = new HashMap();
        this.modifiableGlobals = new HashSet();
        this.modifiableLocals = new HashSet();
    }

    private HashMapContext(boolean noInit) {
        this.localVars = new HashMap();
        this.localFunctions = new HashMap();
        this.modifiableLocals = new HashSet();
    }

    public JexlContext createNewFrame() {
        HashMapContext out = new HashMapContext(true);
        out.globalFunctions = this.globalFunctions;
        out.globalVars = this.globalVars;
        out.modifiableGlobals = this.modifiableGlobals;
        return out;
    }

    public void defineLocalFunction(String name, FunctionDef def) throws ExpressionException {
        if (this.localFunctions.containsKey(name)) {
            throw new ParseException("Cannot redefine function " + name);
        }
        this.localFunctions.put(name, def);
    }

    public void exportLocalVariable(String name) throws ExpressionException {
        Object val = this.localVars.remove(name);
        this.setGlobalVariable(name, val, true);
    }

    public FunctionDef getFunction(String name) {
        FunctionDef out = (FunctionDef)this.localFunctions.get(name);
        if (out != null) {
            return out;
        }
        Object o = this.localVars.get(name);
        if (o instanceof FunctionDef) {
            return (FunctionDef)o;
        }
        out = (FunctionDef)this.globalFunctions.get(name);
        if (out != null) {
            return out;
        }
        o = this.globalVars.get(name);
        if (o instanceof FunctionDef) {
            return (FunctionDef)o;
        }
        return null;
    }

    public Object getVariableValue(String name) {
        if (this.localVars.containsKey(name)) {
            return this.localVars.get(name);
        }
        return this.globalVars.get(name);
    }

    public void setVariable(String name, Object value) throws ExpressionException {
        if (this.localVars.containsKey(name) || !this.globalVars.containsKey(name)) {
            this.setLocalVariable(name, value, true);
        } else {
            this.setGlobalVariable(name, value, true);
        }
    }

    public void setGlobalVariable(String name, Object value, boolean modifiable) throws ExpressionException {
        if (this.globalVars.containsKey(name) && !this.modifiableGlobals.contains(name)) {
            throw new ExpressionException("Cannot reset value of unmodifiable global variable " + name);
        }
        this.globalVars.put(name, value);
        if (modifiable) {
            this.modifiableGlobals.add(name);
        }
    }

    public void setLocalVariable(String name, Object value, boolean modifiable) throws ExpressionException {
        if (this.localVars.containsKey(name) && !this.modifiableLocals.contains(name)) {
            throw new ExpressionException("Cannot reset value of unmodifiable local variable " + name);
        }
        this.localVars.put(name, value);
        if (modifiable) {
            this.modifiableLocals.add(name);
        }
    }

    public void defineGlobalFunction(String name, FunctionDef def) throws ExpressionException {
        if (this.globalFunctions.containsKey(name)) {
            throw new ParseException("Cannot redefine function " + name);
        }
        this.globalFunctions.put(name, def);
    }
}

