/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.ASTIdentifier;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.util.Coercion;
import org.bbop.expression.util.Introspector;
import org.bbop.expression.util.introspection.Info;
import org.bbop.expression.util.introspection.VelPropertyGet;

public class ASTArrayAccess
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTArrayAccess.class);
    private static final Info DUMMY = new Info("", 1, 1);

    public ASTArrayAccess(int id) {
        super(id);
    }

    public ASTArrayAccess(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object execute(Object obj, JexlContext jc) throws Exception {
        ASTIdentifier base = (ASTIdentifier)this.jjtGetChild(0);
        Object result = base.execute(obj, jc);
        for (int i = 1; i < this.jjtGetNumChildren(); ++i) {
            Object loc = ((SimpleNode)this.jjtGetChild(i)).value(jc);
            if (loc == null) {
                return null;
            }
            result = ASTArrayAccess.evaluateExpr(result, loc, this);
        }
        return result;
    }

    public Object value(JexlContext jc) throws Exception {
        ASTIdentifier base = (ASTIdentifier)this.jjtGetChild(0);
        Object o = base.value(jc);
        for (int i = 1; i < this.jjtGetNumChildren(); ++i) {
            Object loc = ((SimpleNode)this.jjtGetChild(i)).value(jc);
            if (loc == null) {
                return null;
            }
            o = ASTArrayAccess.evaluateExpr(o, loc, this);
        }
        return o;
    }

    public static Object evaluateExpr(Object o, Object loc, SimpleNode node) throws Exception {
        if (o == null) {
            return null;
        }
        if (loc == null) {
            return null;
        }
        if (o instanceof Map) {
            if (!((Map)o).containsKey(loc)) {
                return null;
            }
            return ((Map)o).get(loc);
        }
        if (o instanceof List) {
            int idx = Coercion.coerceInteger(loc);
            try {
                return ((List)o).get(idx);
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }
        if (o.getClass().isArray()) {
            int idx = Coercion.coerceInteger(loc);
            try {
                return Array.get(o, idx);
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                return null;
            }
        }
        String s = loc.toString();
        VelPropertyGet vg = Introspector.getUberspect().getPropertyGet(o, s, DUMMY);
        if (vg != null) {
            return vg.invoke(o);
        }
        node.throwExpressionException("Unsupported object type for array [] accessor");
        return null;
    }

    public String getIdentifierString() {
        return ((ASTIdentifier)this.jjtGetChild(0)).getIdentifierString();
    }
}

