/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.FunctionDef;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.BreakLoopException;
import org.bbop.expression.parser.ParseException;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.ReturnValueException;
import org.bbop.expression.parser.SimpleNode;

public class ASTJexlScript
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTJexlScript.class);
    protected Map localFunctions = new HashMap();

    public ASTJexlScript(int id) {
        super(id);
    }

    public void defineLocalFunction(JexlContext context, String name, FunctionDef def) throws Exception {
        this.localFunctions.put(name, def);
        context.setLocalVariable(name, def, false);
    }

    public FunctionDef getFunction(String name, JexlContext context) {
        FunctionDef out = (FunctionDef)this.localFunctions.get(name);
        if (out == null) {
            out = context.getFunction(name);
        }
        return out;
    }

    public ASTJexlScript(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc) throws ExpressionException {
        int numChildren = this.jjtGetNumChildren();
        Object result = null;
        for (int i = 0; i < numChildren; ++i) {
            SimpleNode child = (SimpleNode)this.jjtGetChild(i);
            try {
                result = child.value(jc);
                continue;
            }
            catch (ReturnValueException ex) {
                return ex.getValue();
            }
            catch (BreakLoopException ex) {
                throw new ParseException("Cannot call break outside of a loop");
            }
            catch (ExpressionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExpressionException(ex);
            }
        }
        return result;
    }

    public void jjtClose() {
    }
}

