/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CheckMemoryThread
extends Thread {
    protected static final Logger logger = Logger.getLogger(CheckMemoryThread.class);
    long minMemory;
    long maxMemory = Runtime.getRuntime().maxMemory();
    long interval = 40000L;
    private boolean halt = false;

    public CheckMemoryThread() {
        this.minMemory = this.maxMemory / 10L;
        this.setDaemon(true);
        logger.info((Object)("CheckMemoryThread: max heap size = " + this.maxMemory / 0x100000L + " MB; warn if available memory < " + this.minMemory / 0x100000L + " MB"));
    }

    public void checkFreeMemory() {
        long memoryUsed = Runtime.getRuntime().totalMemory();
        long freeMemory = this.maxMemory - memoryUsed;
        if (freeMemory < this.minMemory) {
            logger.info((Object)("checkFreeMemory: free memory = " + freeMemory / 0x100000L + "MB, total memory used = " + memoryUsed / 0x100000L + "MB.  Garbage collecting."));
            try {
                System.gc();
                CheckMemoryThread.sleep(2000L);
                System.gc();
                CheckMemoryThread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            memoryUsed = Runtime.getRuntime().totalMemory();
            freeMemory = this.maxMemory - memoryUsed;
            if (freeMemory < this.minMemory) {
                String m = "WARNING: you are almost out of memory (" + freeMemory / 0x100000L + " MB left).\nIf you run out of memory, this application could crash and you could lose your work.\nWe recommend saving now, then exiting the application and restarting.";
                logger.info((Object)m);
                JOptionPane.showMessageDialog(null, m);
                logger.info((Object)("checkFreeMemory: free memory = " + freeMemory / 0x100000L + "MB, total memory used = " + memoryUsed / 0x100000L + "MB"));
                this.halt();
            }
        }
    }

    public void halt() {
        this.halt = true;
        this.interrupt();
    }

    public void run() {
        while (!this.halt) {
            try {
                CheckMemoryThread.sleep(this.interval);
                this.checkFreeMemory();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

