/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.bbop.framework.ComponentManager;
import org.bbop.framework.GUIComponentFactory;
import org.bbop.framework.GUIManager;
import org.bbop.framework.dock.Perspective;
import org.bbop.swing.AbstractDynamicMenuItem;
import org.bbop.swing.DynamicMenu;
import org.bbop.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewMenu
extends AbstractDynamicMenuItem {
    protected static final Logger logger = Logger.getLogger(ViewMenu.class);

    public ViewMenu() {
        super("View");
    }

    public List<Component> getItems() {
        ArrayList<Component> out = new ArrayList<Component>();
        DynamicMenu perspectivesMenu = new DynamicMenu("Layouts"){

            @Override
            public List<Component> getItems() {
                ButtonGroup group = new ButtonGroup();
                LinkedList<Component> out = new LinkedList<Component>();
                for (final Perspective perspective : ComponentManager.getManager().getPerspectives()) {
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(new AbstractAction(perspective.getName()){

                        public void actionPerformed(ActionEvent e) {
                            ComponentManager.getManager().setPerspective(perspective);
                        }
                    });
                    group.add(item);
                    if (ObjectUtil.equals(ComponentManager.getManager().getCurrentPerspective(), perspective)) {
                        item.setSelected(true);
                    }
                    out.add(item);
                }
                out.add(new JSeparator());
                JMenuItem importPerspectiveItem = new JMenuItem(new AbstractAction("Import perspective..."){

                    public void actionPerformed(ActionEvent e) {
                        JFileChooser chooser = new JFileChooser();
                        if (chooser.showOpenDialog(GUIManager.getManager().getFrame()) == 0) {
                            File file = chooser.getSelectedFile();
                            if (!file.getName().endsWith(".idw")) {
                                JOptionPane.showMessageDialog(null, "File " + file + " doesn't end with .idw--can't import as perspective.");
                                return;
                            }
                            ComponentManager.getManager().importPerspective(file);
                        }
                    }
                });
                final Perspective current = ComponentManager.getManager().getDriver().getCurrentPerspective();
                JMenuItem savePerspectiveAsItem = new JMenuItem(new AbstractAction("Save current perspective as..."){

                    public void actionPerformed(ActionEvent e) {
                        String name = JOptionPane.showInputDialog("New perspective name");
                        if (name != null) {
                            ComponentManager.getManager().savePerspectiveAs(current, name);
                        }
                    }
                });
                JMenuItem deleteItem = new JMenuItem(new AbstractAction("Delete current perspective"){

                    public void actionPerformed(ActionEvent e) {
                        ComponentManager.getManager().deletePerspective(current);
                    }
                });
                out.add(importPerspectiveItem);
                boolean builtin = current == null ? false : current.getBuiltIn();
                deleteItem.setEnabled(!builtin);
                out.add(savePerspectiveAsItem);
                out.add(deleteItem);
                return out;
            }
        };
        DynamicMenu showMenu = new DynamicMenu("Show"){

            @Override
            public List<Component> getItems() {
                LinkedList<Component> out = new LinkedList<Component>();
                HashMap factoryMap = new HashMap();
                Collection<GUIComponentFactory<?>> f = ComponentManager.getManager().getFactories();
                for (GUIComponentFactory<?> factory : f) {
                    if (!factory.showInMenus()) continue;
                    ArrayList factories = (ArrayList)factoryMap.get((Object)factory.getCategory());
                    if (factories == null) {
                        factories = new ArrayList();
                        factoryMap.put(factory.getCategory(), factories);
                    }
                    factories.add(factory);
                }
                Comparator<GUIComponentFactory> factoryComparator = new Comparator<GUIComponentFactory>(){

                    @Override
                    public int compare(GUIComponentFactory o1, GUIComponentFactory o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                };
                for (GUIComponentFactory.FactoryCategory category : GUIComponentFactory.FactoryCategory.values()) {
                    List factories = (List)factoryMap.get((Object)category);
                    if (factories == null || factories.size() <= 0) continue;
                    Collections.sort(factories, factoryComparator);
                    DynamicMenu subMenu = new DynamicMenu(category.toString());
                    for (final GUIComponentFactory factory : factories) {
                        JMenuItem item = new JMenuItem(new AbstractAction(factory.getName()){

                            public void actionPerformed(ActionEvent e) {
                                ComponentManager.getManager().showComponent(factory, null);
                            }
                        });
                        subMenu.add(item);
                    }
                    out.add(subMenu);
                }
                return out;
            }
        };
        out.add(perspectivesMenu);
        out.add(showMenu);
        return out;
    }
}

