/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.Logger;

public class FileUtil {
    protected static final Logger logger = Logger.getLogger(FileUtil.class);

    public static void ensureExists(File file, String resource) throws IOException {
        ClassLoader loader = FileUtil.getSystemClassLoader();
        FileUtil.ensureExists(file, loader, resource);
    }

    public static void ensureExists(File file, ClassLoader loader, String resource) throws IOException {
        if (file.exists()) {
            return;
        }
        if (loader == null) {
            throw new IOException("ClassLoader is null, can't load resource.");
        }
        if (resource == null) {
            throw new NullPointerException("Can't load from null resource");
        }
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            try {
                is = FileUtil.findInputStream(resource);
            }
            catch (FileNotFoundException e) {
                is = FileUtil.findInputStream("/" + resource);
            }
            if (is == null) {
                throw new FileNotFoundException("Couldn't find resource " + resource);
            }
        }
        new File(file.getParent()).mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        logger.info((Object)("Creating " + file.getAbsolutePath() + " from resource " + resource));
        int next = is.read();
        while (next != -1) {
            ((OutputStream)os).write(next);
            next = is.read();
        }
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    private static InputStream findInputStream(String resource) throws FileNotFoundException {
        URL u = FileUtil.class.getResource(resource);
        if (u == null) {
            throw new FileNotFoundException("cant get resource " + resource);
        }
        InputStream is = null;
        try {
            is = u.openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is == null) {
            throw new FileNotFoundException("failed to open stream " + resource);
        }
        return is;
    }

    public static ClassLoader getSystemClassLoader() {
        try {
            Method loaderMethod = ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]);
            Object out = loaderMethod.invoke(null, new Object[0]);
            return (ClassLoader)out;
        }
        catch (Exception e) {
            return Class.class.getClassLoader();
        }
    }
}

