/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.rdbms.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bbop.rdbms.FromClause;
import org.bbop.rdbms.GroupByClause;
import org.bbop.rdbms.OrderByClause;
import org.bbop.rdbms.RelationalQuery;
import org.bbop.rdbms.RelationalTerm;
import org.bbop.rdbms.SelectClause;
import org.bbop.rdbms.WhereClause;
import org.bbop.rdbms.impl.AbstractRelationalTerm;
import org.bbop.rdbms.impl.SqlFromClauseImpl;
import org.bbop.rdbms.impl.SqlGroupByClauseImpl;
import org.bbop.rdbms.impl.SqlOrderByClauseImpl;
import org.bbop.rdbms.impl.SqlSelectClauseImpl;
import org.bbop.rdbms.impl.SqlWhereClauseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQueryImpl
extends AbstractRelationalTerm
implements RelationalQuery {
    protected SelectClause selectClause = new SqlSelectClauseImpl();
    protected FromClause fromClause = new SqlFromClauseImpl();
    protected WhereClause whereClause = new SqlWhereClauseImpl();
    protected OrderByClause orderByClause = new SqlOrderByClauseImpl();
    protected GroupByClause groupByClause = new SqlGroupByClauseImpl();
    protected Map<String, Integer> aliasNumByTable = new HashMap<String, Integer>();

    public SqlQueryImpl(SelectClause sc, FromClause fc, WhereClause wc, OrderByClause obc, GroupByClause gbc) {
        if (sc != null) {
            this.selectClause = sc;
        }
        if (fc != null) {
            this.fromClause = fc;
        }
        if (wc != null) {
            this.whereClause = wc;
        }
        if (obc != null) {
            this.orderByClause = obc;
        }
        if (gbc != null) {
            this.groupByClause = gbc;
        }
    }

    public SqlQueryImpl(SelectClause sc, FromClause fc, WhereClause wc) {
        this(sc, fc, wc, null, null);
    }

    public SqlQueryImpl(String sc, String fc, String wc) {
        this(new SqlSelectClauseImpl(sc), new SqlFromClauseImpl(fc), new SqlWhereClauseImpl(wc), null, null);
    }

    public SqlQueryImpl() {
    }

    @Override
    public String toSQL() {
        return this.getSelectClause().toSQL() + " " + this.getFromClause().toSQL() + " " + this.getWhereClause().toSQL() + " " + this.getGroupByClause().toSQL() + " " + this.getOrderByClause().toSQL();
    }

    @Override
    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    @Override
    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    @Override
    public void setSelectClause(String selectClause) {
        this.selectClause = new SqlSelectClauseImpl(selectClause);
    }

    @Override
    public void addTable(String tbl) {
        this.fromClause.addRelation(tbl);
    }

    @Override
    public void addTable(String tbl, String alias) {
        this.fromClause.addRelation(tbl + " AS " + alias);
    }

    @Override
    public String addAutoAliasedTable(String tbl) {
        int num = 0;
        if (!this.aliasNumByTable.containsKey(tbl)) {
            this.aliasNumByTable.put(tbl, num);
        } else {
            num = this.aliasNumByTable.get(tbl);
            this.aliasNumByTable.put(tbl, ++num);
        }
        String aliasTbl = tbl + "__" + num;
        this.addTable(tbl, aliasTbl);
        return aliasTbl;
    }

    @Override
    public String addAutoAliasedTable(String tbl, String preferredAlias) {
        if (preferredAlias == null) {
            return this.addAutoAliasedTable(tbl);
        }
        int num = 0;
        if (!this.aliasNumByTable.containsKey(preferredAlias)) {
            this.aliasNumByTable.put(preferredAlias, num);
        } else {
            num = this.aliasNumByTable.get(preferredAlias);
            this.aliasNumByTable.put(preferredAlias, ++num);
        }
        String aliasTbl = num == 0 ? preferredAlias : preferredAlias + "__" + num;
        this.addTable(tbl, aliasTbl);
        return aliasTbl;
    }

    @Override
    public FromClause getFromClause() {
        return this.fromClause;
    }

    @Override
    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    @Override
    public GroupByClause getGroupByClause() {
        return this.groupByClause;
    }

    @Override
    public void setGroupByClause(GroupByClause groupByClause) {
        this.groupByClause = groupByClause;
    }

    @Override
    public void setGroupByClause(String groupByClause) {
        this.groupByClause = new SqlGroupByClauseImpl(groupByClause);
    }

    @Override
    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    @Override
    public void setOrderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    @Override
    public void setOrderByClause(String orderByClause) {
        this.orderByClause = new SqlOrderByClauseImpl(orderByClause);
    }

    @Override
    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    @Override
    public void setWhereClause(WhereClause whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public Collection<Object> getPlaceHolderVals() {
        return this.whereClause.getPlaceHolderVals();
    }

    @Override
    public ResultSet execute(Connection conn) throws SQLException {
        String sql = this.toSQL();
        Logger.getLogger("org.bbop.rdbms").fine(this.toSQL());
        PreparedStatement stmt = conn.prepareStatement(sql);
        int i = 1;
        for (Object v : this.getPlaceHolderVals()) {
            Logger.getLogger("org.bbop.rdbms").fine("  ?= " + v);
            if (v instanceof String) {
                stmt.setString(i, (String)v);
            } else if (v instanceof Boolean) {
                stmt.setBoolean(i, (Boolean)v);
            } else if (v instanceof Integer) {
                stmt.setInt(i, (Integer)v);
            } else if (v instanceof Float) {
                stmt.setFloat(i, ((Float)v).floatValue());
            } else {
                throw new SQLException("dunno what to do with " + v);
            }
            ++i;
        }
        return stmt.executeQuery();
    }

    @Override
    public String getTableAliasReferencedInJoin(String joinCol, String table) {
        Map<String, String> aliasMap = this.fromClause.getAliasMap();
        for (RelationalTerm rt : this.getWhereClause().getConstraintSet().getConstraints()) {
            String[] toks2;
            String alias;
            String[] toks;
            String c = rt.toString();
            if (!c.contains("=") || (toks = c.split(" += +", 2)).length != 2) continue;
            String jc2 = null;
            if (toks[0].equals(joinCol)) {
                jc2 = toks[1];
            } else if (toks[1].equals(joinCol)) {
                jc2 = toks[0];
            }
            if (jc2 == null || !jc2.contains(".") || !aliasMap.containsKey(alias = (toks2 = c.split("\\.", 2))[0]) || !aliasMap.get(alias).equals(table)) continue;
            return alias;
        }
        return null;
    }
}

